/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.tasks;

import com.atlassian.clover.ProgressListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;

public class ProgressIndicatorAdapter
implements ProgressListener {
    private static final Logger LOG = Logger.getInstance((String)"CloverProgressIndicator");
    private final ProgressIndicator progressIndicator;
    private String lastDesc;
    private float lastReportedPc;
    private final float step = 0.01f;

    public ProgressIndicatorAdapter(ProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
        progressIndicator.setIndeterminate(true);
    }

    @Override
    public void handleProgress(String desc, float pc) {
        this.progressIndicator.checkCanceled();
        if (!desc.equals(this.lastDesc)) {
            LOG.info(desc);
            this.progressIndicator.setText2(desc);
            this.lastDesc = desc;
            this.lastReportedPc = -1.0f;
        }
        if (pc <= 0.0f) {
            if (!this.progressIndicator.isIndeterminate()) {
                this.progressIndicator.setIndeterminate(true);
            }
        } else if (this.progressIndicator.isIndeterminate()) {
            this.progressIndicator.setIndeterminate(false);
            this.lastReportedPc = pc;
            this.progressIndicator.setFraction((double)pc);
        } else if (pc < this.lastReportedPc || pc - this.lastReportedPc > 0.01f) {
            this.lastReportedPc = pc;
            this.progressIndicator.setFraction((double)pc);
        }
    }
}

