/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.tasks;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.util.MiscUtils;
import com.atlassian.clover.idea.util.tasks.CancellableTaskDelegate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CancellableTask
extends Task.Backgroundable {
    private final CancellableTaskDelegate delegate;
    private ProgressIndicator progressIndicator;
    private boolean alreadyCancelled;

    public CancellableTask(@Nullable Project project, @NotNull CancellableTaskDelegate delegate) {
        super(project, delegate.getTitle());
        this.delegate = delegate;
    }

    public final void run(@NotNull ProgressIndicator indicator) {
        this.setProgressIndicator(indicator);
        try {
            this.delegate.run(indicator);
            if (this.isHeadless()) {
                MiscUtils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CancellableTask.this.onSuccess();
                    }
                });
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance().warn("Task finished with an exception", e);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    CancellableTask.this.onCancel();
                }
            });
        }
    }

    public void onSuccess() {
        this.delegate.onSuccess();
        this.onFinish();
    }

    public void onCancel() {
        this.delegate.onCancel();
        this.onFinish();
    }

    protected void onFinish() {
    }

    protected synchronized void setProgressIndicator(ProgressIndicator indicator) throws ProcessCanceledException {
        if (this.alreadyCancelled) {
            throw new ProcessCanceledException();
        }
        this.progressIndicator = indicator;
    }

    public synchronized void cancel() {
        this.alreadyCancelled = true;
        if (this.progressIndicator != null) {
            this.progressIndicator.cancel();
        }
    }
}

