/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.l10n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class CloverIdeaPluginMessages {
    private static final String BUNDLE_NAME = "/l10n/plugin";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("/l10n/plugin");

    private CloverIdeaPluginMessages() {
    }

    public static String getString(String key) {
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
    }

    public static String getFormattedString(String key, Object ... arg) {
        String format;
        try {
            format = RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return "!" + key + "!";
        }
        return MessageFormat.format(format, arg);
    }

    public static String INITSTRING() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.initstring");
    }

    public static String INITSTRING_BLURB() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.initstringBlurb");
    }

    public static String INITSTRING_AUTOMATIC() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.initstringAutomatic");
    }

    public static String INITSTRING_USER_SPECIFIED() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.initstringUserSpecified");
    }

    public static String INITSTRING_RELATIVE() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.initstringRelative");
    }

    public static String ENABLE_CLOVER_COVERAGE() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.enableCloverCoverage");
    }

    public static String INSTRUMENTATION() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.instrumentation");
    }

    public static String COMPILATION() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.compilation");
    }

    public static String FILTERING() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.filtering");
    }

    public static String LICENSE() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.license");
    }

    public static String FLUSH_POLICY() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.flushPolicy");
    }

    public static String FLUSH_COVERAGE_WHEN() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.flushCoverageWhen");
    }

    public static String FLUSH_POLICY_EXPLANATION() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.flushPolicyExplanation");
    }

    public static String FLUSH_INTERVAL() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.flushInterval");
    }

    public static String FLUSH_POLICY_THREADED() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.threadedFlush");
    }

    public static String FLUSH_POLICY_INTERVAL() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.intervalFlush");
    }

    public static String FLUSH_POLICY_DIRECTED() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.directedFlush");
    }

    public static String OUTPUT_DIR() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.outputDir");
    }

    public static String CUSTOM_OUTPUT_ROOT_IS_RELATIVE() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.customOutputRootIsRelative");
    }

    public static String PLACE_IN_PROJECT_DIRS() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.placeInProjectDirs");
    }

    public static String PLACE_IN_USER_DIRS() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.placeInUserDirs");
    }

    public static String QUALIFY_JAVA_LANG() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.qualifyJavaLang");
    }

    public static String METHOD_CONTEXT_FILTER_INSTRUCTIONS_HTML() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.methodContextFilterInstructionsHtml");
    }

    public static String STATEMENT_CONTEXT_FILTER_INSTRUCTIONS_HTML() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.statementContextFilterInstructionsHtml");
    }

    public static String WHEN_REBUILDING() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.whenRebuilding");
    }

    public static String LEAVE_COVERAGE() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.leaveOnRebuild");
    }

    public static String CLEAR_COVERAGE() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.clearOnRebuild");
    }

    public static String PROMPT_ME_ON_REBUILD() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.promptOnRebuild");
    }

    public static String WHEN_CONTEXT_CHANGES() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.whenContextChanges");
    }

    public static String REBUILD_ON_CONTEXT_CHANGE() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.rebuildOnContextChange");
    }

    public static String IGNORE_ON_CONTEXT_CHANGE() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.ignoreOnContextChange");
    }

    public static String PROMPT_ME_ON_CONTEXT_CHANGE() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.promptOnContextChange");
    }

    public static String PRIME_AWT_IN_UI_THREAD() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.primeAWTInUIThread");
    }

    public static String AUTO_REFRESH_COVERAGE_DATA() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.autoRefreshCoverageData");
    }

    public static String COVERAGE_DATA() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.coverageData");
    }

    public static String TWO_SECONDS() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.twoSeconds");
    }

    public static String FIVE_SECONDS() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.fiveSeconds");
    }

    public static String TEN_SECONDS() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.tenSeconds");
    }

    public static String TWENTY_SECONDS() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.twentySeconds");
    }

    public static String SPAN() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.span");
    }

    public static String SPAN_BLURB() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.spanBlurb");
    }

    public static String MISC_PREFERENCES() {
        return CloverIdeaPluginMessages.getString("PreferencesPage.miscellaneous");
    }

    public static String FILE_FILTERING() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.fileFiltering");
    }

    public static String FILE_FILTERING_BLURB() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.fileFilteringBlurb");
    }

    public static String FILE_FILTERING_INCLUDE() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.fileFilteringInclude");
    }

    public static String FILE_FILTERING_EXCLUDE() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.fileFilteringExclude");
    }

    public static String CONTEXT_FILTERING() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.contextFiltering");
    }

    public static String CONTEXT_FILTERING_BLURB() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.contextFilteringBlurb");
    }

    public static String MISC_INSTRUMENTATION() {
        return CloverIdeaPluginMessages.getString("ProjectPropertyPage.miscellaneousInstrumentationSettings");
    }

    public static String NOT_COVERED() {
        return CloverIdeaPluginMessages.getString("CoverageAnnotation.notCovered");
    }

    public static String COVERED() {
        return CloverIdeaPluginMessages.getString("CoverageAnnotation.covered");
    }

    public static String COVERAGE_ELEMENT_COL() {
        return CloverIdeaPluginMessages.getString("CoverageView.elementColumn");
    }

    public static String COVERAGE_ELEMENT_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("CoverageView.elementColumnToolTip");
    }

    public static String COVERAGE_COL() {
        return CloverIdeaPluginMessages.getString("CoverageView.coverageColumn");
    }

    public static String COVERAGE_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("CoverageView.coverageColumnToolTip");
    }

    public static String AVG_METH_COMPLEXITY_COL() {
        return CloverIdeaPluginMessages.getString("CoverageView.avgMethComplexityColumn");
    }

    public static String AVG_METH_COMPLEXITY_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("CoverageView.avgMethComplexityColumnToolTip");
    }

    public static String TOTAL_COMPLEXITY_COL() {
        return CloverIdeaPluginMessages.getString("CoverageView.totalComplexityColumn");
    }

    public static String TOTAL_COMPLEXITY_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("CoverageView.totalComplexityColumnToolTip");
    }

    public static String TEST_COL() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.testColumn");
    }

    public static String TESTT_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.testColumnToolTip");
    }

    public static String TEST_STARTED_COL() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.startedColumn");
    }

    public static String TEST_STARTED_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.startedColumnToolTip");
    }

    public static String TEST_STATUS_COL() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.statusColumn");
    }

    public static String TEST_STATUS_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.statusColumnToolTip");
    }

    public static String TEST_TIME_COL() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.timeColumn");
    }

    public static String TEST_TIME_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.timeColumnToolTip");
    }

    public static String TEST_MESSAGE_COL() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.messageColumn");
    }

    public static String TEST_MESSAGE_COL_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("TestRunExplorerView.messageColumnToolTip");
    }

    public static String LICENSE_SUMMARY() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseSummary");
    }

    public static String LICENSE_STATUS() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseStatus");
    }

    public static String LICENSE_STATUS_LICENSED() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseStatusLicensed");
    }

    public static String LICENSE_TYPE() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseType");
    }

    public static String LICENSE_STATEMENT() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseStatement");
    }

    public static String LICENSE_TEXT() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseText");
    }

    public static String LICENSE_TEXT_EXPLANATION(String nextSteps) {
        return CloverIdeaPluginMessages.getFormattedString("LicensePreferencesPage.licenseTextExplanation", nextSteps);
    }

    public static String LICENSE_TEXT_PASTE() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseTextPaste");
    }

    public static String LICENSE_TEXT_LOAD() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseTextLoad");
    }

    public static String LICENSE_FILE_ERROR_TITLE() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseFileErrorTitle");
    }

    public static String LICENSE_FILE_ERROR_MESSAGE(String path, String error) {
        return CloverIdeaPluginMessages.getFormattedString("LicensePreferencesPage.licenseFileErrorMessage", path, error);
    }

    public static String LICENSE_FILE_CANT_READ() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseFileCantRead");
    }

    public static String LICENSE_FILE_NOT_LICENSE() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseFileNotLicense");
    }

    public static String LICENSE_MAINTENANCE_RENEW() {
        return CloverIdeaPluginMessages.getString("LicensePreferencesPage.licenseRenew");
    }

    public static String METRICS_SUMMARY() {
        return CloverIdeaPluginMessages.getString("CoverageView.metricsSummaryDetails");
    }

    public static String LOADING_DECORATION(String label) {
        return CloverIdeaPluginMessages.getFormattedString("CoverageView.loadingDecoration", label);
    }

    public static String PROJECT_RISKS() {
        return CloverIdeaPluginMessages.getString("CloudEditor.projectRisks");
    }

    public static String PACKAGE_RISKS() {
        return CloverIdeaPluginMessages.getString("CloudEditor.packageRisks");
    }

    public static String QUICK_WINS() {
        return CloverIdeaPluginMessages.getString("CloudEditor.quickWins");
    }

    public static String SHOW_AGGREGATE_CLOUD() {
        return CloverIdeaPluginMessages.getString("CloudEditor.showAggregateCloud");
    }

    public static String FAILED_TO_GENERATE_CLOUD() {
        return CloverIdeaPluginMessages.getString("OpenCloudAction.failedToGenerateCloud");
    }

    public static String FAILED_TO_OPEN_CLOUD_EDITOR() {
        return CloverIdeaPluginMessages.getString("OpenCloudAction.failedToOpenCloudEditor");
    }

    public static String GENERATING_CLOUD_FOR(String projectName) {
        return CloverIdeaPluginMessages.getFormattedString("OpenCloudAction.generatingCloudForProject", projectName);
    }

    public static String REFRESH_CLOUD() {
        return CloverIdeaPluginMessages.getString("RefreshCloudAction.refreshCloud");
    }

    public static String REFRESH_CLOUD_BUTTON() {
        return CloverIdeaPluginMessages.getString("RefreshCloudAction.refresh");
    }

    public static String REFRESH_CLOUD_TOOL_TIP() {
        return CloverIdeaPluginMessages.getString("RefreshCloudAction.refreshCloudToolTip");
    }

    public static String CLOVER_WORKING_SET() {
        return CloverIdeaPluginMessages.getString("CloverWorkingSet.title");
    }

    public static String HIERARCHY_LAYOUT() {
        return CloverIdeaPluginMessages.getString("CoverageView.hierarchyStyleMenuTitle");
    }

    public static String BLOCK_CONTEXT_FILTER_INSTRUCTIONS() {
        return CloverIdeaPluginMessages.getString("Contexts.blockContextFilterInstructions");
    }

    public static String REGEXP_CONTEXT_FILTER_INSTRUCTIONS() {
        return CloverIdeaPluginMessages.getString("Contexts.regexpContextFilterInstructions");
    }

    public static String RESERVED_BLOCK_CONTEXT(String name) {
        return CloverIdeaPluginMessages.getString("Contexts.block." + name);
    }

    public static String RESERVED_REGEX_CONTEXT(String name) {
        return CloverIdeaPluginMessages.getString("Contexts.regex." + name);
    }

    public static String LAUNCH_TOOLBAR_LAST_CLOVERED_NAME() {
        return CloverIdeaPluginMessages.getString("launch.toolbar.last.clovered.name");
    }

    public static String LAUNCH_TOOLBAR_LAST_CLOVERED_DESCRIPTION() {
        return CloverIdeaPluginMessages.getString("launch.commands.last.clovered.description");
    }

    public static String REPORT_SHOW_IN_BROWSER() {
        return CloverIdeaPluginMessages.getString("Report.showInBrowser");
    }

    public static String SYSTEM_BROWSER() {
        return CloverIdeaPluginMessages.getString("Report.systemBrowser");
    }

    public static String ECLIPSE_BROWSER() {
        return CloverIdeaPluginMessages.getString("Report.eclipseBrowser");
    }

    public static String REPORT_MESSAGEBOX_TITLE() {
        return CloverIdeaPluginMessages.getString("Report.messageBoxTitle");
    }

    public static String REPORT_SUCCESS_MESSAGE() {
        return CloverIdeaPluginMessages.getString("Report.successMessage");
    }

    public static String REPORT_CANCEL_MESSAGE() {
        return CloverIdeaPluginMessages.getString("Report.cancelMessage");
    }
}

