/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util.jdom;

import clover.org.apache.commons.lang3.StringUtils;
import com.atlassian.clover.idea.util.jdom.JDOMUtil;
import com.atlassian.clover.idea.util.jdom.Property;
import com.atlassian.clover.idea.util.jdom.PropertyUtil;
import com.atlassian.clover.util.collections.Pair;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class JDOMExternUtil {
    private static final String JARJAR_PREFIX = "repkg.";
    private static final TypeConverter[] TYPE_CONVERTERS = new TypeConverter[]{new IntegerConverter(), new LongConverter(), new ShortConverter(), new ByteConverter(), new DoubleConverter(), new FloatConverter(), new BooleanConverter(), new StringConverter(), new ColorConverter(), new ColorPairConverter(), new MapConverter(), new ListConverter(), new EnumConverter(), new DefaultConverter()};

    private JDOMExternUtil() {
    }

    public static void writeTo(Element root, Object obj) throws Exception {
        Class<?> type;
        if (root == null) {
            throw new IllegalArgumentException("can not write to null root element.");
        }
        Class<?> clazz = type = obj != null ? obj.getClass() : null;
        if (type != null) {
            JDOMExternUtil.setClassAttribute(root, type);
        }
        JDOMExternUtil.writeTo(root, type, obj);
    }

    private static void writeTo(Element root, Class type, Object obj) throws Exception {
        TypeConverter converter = JDOMExternUtil.lookupConverter(type);
        if (converter == null) {
            throw new UnsupportedOperationException();
        }
        converter.write(root, obj);
    }

    public static Object readFrom(Element root) throws Exception {
        if (root == null) {
            throw new IllegalArgumentException("can not read from null root element.");
        }
        Class type = JDOMExternUtil.getClassFromElement(root);
        return JDOMExternUtil.readFrom(root, type);
    }

    public static void readTo(Element root, Object obj) throws Exception {
        TypeConverter converter = JDOMExternUtil.lookupConverter(obj.getClass());
        if (converter == null) {
            throw new UnsupportedOperationException();
        }
        converter.read(root, obj);
    }

    private static Object readFrom(Element root, Class type) throws Exception {
        TypeConverter converter = JDOMExternUtil.lookupConverter(type);
        if (converter != null) {
            return converter.read(root);
        }
        throw new UnsupportedOperationException();
    }

    private static TypeConverter lookupConverter(Class type) {
        for (TypeConverter converter : TYPE_CONVERTERS) {
            if (!converter.canConvert(type)) continue;
            return converter;
        }
        return null;
    }

    public static String writeToString(Object data) throws Exception {
        return JDOMExternUtil.writeToString("root", data);
    }

    public static String writeToString(String rootName, Object data) throws Exception {
        Document d = new Document(new Element(rootName));
        JDOMExternUtil.writeTo(d.getRootElement(), data);
        return JDOMUtil.writeDocument(d);
    }

    public static Object readFromString(String str) throws Exception {
        Document doc = JDOMUtil.loadDocument(str);
        Element root = doc.getRootElement();
        return JDOMExternUtil.readFrom(root);
    }

    static void setClassAttribute(Element element, Class clazz) {
        String className = clazz.getName();
        String strippedName = className.startsWith(JARJAR_PREFIX) ? className.substring(JARJAR_PREFIX.length()) : className;
        element.setAttribute("class", strippedName);
    }

    static Class getClassFromElement(Element element) throws ClassNotFoundException {
        String className = element.getAttributeValue("class");
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException origException) {
            try {
                return Class.forName(JARJAR_PREFIX + className);
            }
            catch (ClassNotFoundException e1) {
                throw origException;
            }
        }
    }

    private static class DefaultConverter
    implements TypeConverter {
        private DefaultConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return true;
        }

        @Override
        public void write(Element e, Object o) throws Exception {
            Property[] properties;
            if (o == null) {
                e.setAttribute("null", "true");
                return;
            }
            if (e.getAttribute("class") == null) {
                JDOMExternUtil.setClassAttribute(e, o.getClass());
            }
            for (Property property : properties = PropertyUtil.getProperties(o)) {
                if (!property.isReadable() || !property.isWriteable()) continue;
                Object value = property.getValue(o);
                Element propertyElement = new Element(property.getName());
                JDOMExternUtil.writeTo(propertyElement, property.getType(), value);
                e.addContent(propertyElement);
            }
        }

        @Override
        public Object read(Element e) throws Exception {
            if (e.getAttributeValue("null") != null) {
                return null;
            }
            Class type = JDOMExternUtil.getClassFromElement(e);
            Object obj = type.newInstance();
            this.read(e, obj);
            return obj;
        }

        @Override
        public void read(Element e, Object o) throws Exception {
            Property[] properties;
            if (e.getAttributeValue("null") != null) {
                return;
            }
            for (Property property : properties = PropertyUtil.getProperties(o.getClass())) {
                Element propertyElement;
                if (!property.isReadable() || !property.isWriteable() || (propertyElement = e.getChild(property.getName())) == null) continue;
                try {
                    Object value = JDOMExternUtil.readFrom(propertyElement, property.getType());
                    property.setValue(o, value);
                }
                catch (Exception e1) {
                    Logger.getInstance((String)this.getClass().getName()).info("Reading config value", (Throwable)e1);
                }
            }
        }
    }

    private static class EnumConverter
    implements TypeConverter {
        private EnumConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type != null && type.isEnum();
        }

        @Override
        public void write(Element e, Object o) {
            if (e.getAttribute("class") == null) {
                JDOMExternUtil.setClassAttribute(e, o.getClass());
            }
            if (o != null) {
                e.setText(((Enum)o).name());
            } else {
                e.setAttribute("null", "true");
            }
        }

        @Override
        public Object read(Element e) throws Exception {
            if (e.getAttributeValue("null") != null) {
                return null;
            }
            Class clazz = JDOMExternUtil.getClassFromElement(e);
            return Enum.valueOf(clazz, e.getText().trim());
        }

        @Override
        public void read(Element e, Object o) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static class ListConverter
    implements TypeConverter {
        private ListConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type != null && List.class.isAssignableFrom(type);
        }

        @Override
        public void write(Element e, Object o) throws Exception {
            if (o == null) {
                e.setAttribute("null", "true");
                return;
            }
            if (e.getAttribute("class") == null) {
                JDOMExternUtil.setClassAttribute(e, o.getClass());
            }
            for (Object valueObj : (List)o) {
                Element item = new Element("item");
                Class<?> valueType = valueObj.getClass();
                JDOMExternUtil.setClassAttribute(item, valueType);
                JDOMExternUtil.writeTo(item, valueType, valueObj);
                e.addContent(item);
            }
        }

        @Override
        public Object read(Element e) throws Exception {
            if (e.getAttributeValue("null") != null) {
                return null;
            }
            Class type = JDOMExternUtil.getClassFromElement(e);
            List obj = (List)type.newInstance();
            this.read(e, obj);
            return obj;
        }

        @Override
        public void read(Element e, Object o) throws Exception {
            if (e.getAttributeValue("null") != null) {
                return;
            }
            List list = (List)o;
            for (Element element : e.getChildren("item")) {
                try {
                    Class valueType = JDOMExternUtil.getClassFromElement(element);
                    Object valueObj = JDOMExternUtil.readFrom(element, valueType);
                    list.add(valueObj);
                }
                catch (Exception e1) {
                    Logger.getInstance((String)this.getClass().getName()).info("Reading config value", (Throwable)e1);
                }
            }
        }
    }

    private static class MapConverter
    implements TypeConverter {
        private MapConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type != null && Map.class.isAssignableFrom(type);
        }

        @Override
        public void write(Element e, Object o) throws Exception {
            if (o == null) {
                e.setAttribute("null", "true");
                return;
            }
            if (e.getAttribute("class") == null) {
                JDOMExternUtil.setClassAttribute(e, o.getClass());
            }
            for (Map.Entry entry : ((Map)o).entrySet()) {
                Element key = new Element("key");
                Object keyObj = entry.getKey();
                Class<?> keyType = keyObj.getClass();
                JDOMExternUtil.setClassAttribute(key, keyType);
                JDOMExternUtil.writeTo(key, keyType, keyObj);
                Element value = new Element("value");
                Object valueObj = entry.getValue();
                Class<?> valueType = valueObj.getClass();
                JDOMExternUtil.setClassAttribute(value, valueType);
                JDOMExternUtil.writeTo(value, valueType, valueObj);
                Element item = new Element("item");
                item.addContent(key);
                item.addContent(value);
                e.addContent(item);
            }
        }

        @Override
        public void read(Element e, Object o) throws Exception {
            if (e.getAttributeValue("null") != null) {
                return;
            }
            Map map = (Map)o;
            for (Element element : e.getChildren("item")) {
                Element key = element.getChild("key");
                try {
                    Class keyType = JDOMExternUtil.getClassFromElement(key);
                    Object keyObj = JDOMExternUtil.readFrom(key, keyType);
                    Element value = element.getChild("value");
                    Class valueType = JDOMExternUtil.getClassFromElement(value);
                    Object valueObj = JDOMExternUtil.readFrom(value, valueType);
                    map.put(keyObj, valueObj);
                }
                catch (Exception e1) {
                    Logger.getInstance((String)this.getClass().getName()).info("Reading config value", (Throwable)e1);
                }
            }
        }

        @Override
        public Object read(Element e) throws Exception {
            if (e.getAttributeValue("null") != null) {
                return null;
            }
            Class type = JDOMExternUtil.getClassFromElement(e);
            Map obj = (Map)type.newInstance();
            this.read(e, obj);
            return obj;
        }
    }

    private static class StringConverter
    extends BaseConverter {
        private StringConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == String.class;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return e.getText();
        }
    }

    private static class LongConverter
    extends BaseConverter {
        private LongConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Long.class || type == Long.TYPE;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return Long.valueOf(e.getText().trim());
        }
    }

    private static class IntegerConverter
    extends BaseConverter {
        private IntegerConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Integer.class || type == Integer.TYPE;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return Integer.valueOf(e.getText().trim());
        }
    }

    private static class BooleanConverter
    extends BaseConverter {
        private BooleanConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Boolean.class || type == Boolean.TYPE;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return Boolean.valueOf(e.getText().trim());
        }
    }

    private static class ByteConverter
    extends BaseConverter {
        private ByteConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Byte.class || type == Byte.TYPE;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return Byte.valueOf(e.getText());
        }
    }

    private static class ShortConverter
    extends BaseConverter {
        private ShortConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Short.class || type == Short.TYPE;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return Short.valueOf(e.getText().trim());
        }
    }

    private static class FloatConverter
    extends BaseConverter {
        private FloatConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Float.class || type == Float.TYPE;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return Float.valueOf(e.getText());
        }
    }

    private static class DoubleConverter
    extends BaseConverter {
        private DoubleConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Double.class || type == Double.TYPE;
        }

        @Override
        public Object read(Element e) {
            if (this.containsNull(e)) {
                return null;
            }
            return Double.valueOf(e.getText());
        }
    }

    private static class ColorPairConverter
    implements TypeConverter {
        private static final String SEPARATOR = " ";

        private ColorPairConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Pair.class;
        }

        @Override
        public void write(Element e, Object o) {
            Pair pair = (Pair)o;
            if (pair == null || pair.first == null) {
                e.setAttribute("null", "true");
            } else {
                int firstRGB = ((Color)pair.first).getRGB();
                if (pair.second != null) {
                    int secondRGB = ((Color)pair.second).getRGB();
                    e.setText(firstRGB + SEPARATOR + secondRGB);
                } else {
                    e.setText(Integer.toString(firstRGB));
                }
            }
        }

        @Override
        public Object read(Element e) {
            Color secondColor;
            if (e.getAttributeValue("null") != null) {
                return null;
            }
            String[] colors = StringUtils.split(e.getText().trim(), " \t\n\r");
            Color firstColor = colors.length > 0 ? Color.decode(colors[0]) : null;
            Color color = secondColor = colors.length > 1 ? Color.decode(colors[1]) : firstColor;
            if (firstColor == null && secondColor == null) {
                return null;
            }
            return Pair.of(firstColor, secondColor);
        }

        @Override
        public void read(Element e, Object o) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static class ColorConverter
    implements TypeConverter {
        private ColorConverter() {
        }

        @Override
        public boolean canConvert(Class type) {
            return type == Color.class;
        }

        @Override
        public void write(Element e, Object o) {
            if (o != null) {
                e.setText("" + ((Color)o).getRGB());
            } else {
                e.setAttribute("null", "true");
            }
        }

        @Override
        public Object read(Element e) {
            if (e.getAttributeValue("null") != null) {
                return null;
            }
            return Color.decode(e.getText().trim());
        }

        @Override
        public void read(Element e, Object o) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class BaseConverter
    implements TypeConverter {
        private BaseConverter() {
        }

        @Override
        public void write(Element e, Object o) {
            if (o != null) {
                e.setText(o.toString());
            } else {
                e.setAttribute("null", "true");
            }
        }

        protected boolean containsNull(Element e) {
            return e.getAttributeValue("null") != null;
        }

        @Override
        public void read(Element e, Object o) throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    private static interface TypeConverter {
        public boolean canConvert(Class var1);

        public void write(Element var1, Object var2) throws Exception;

        public Object read(Element var1) throws Exception;

        public void read(Element var1, Object var2) throws Exception;
    }
}

