/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util;

import com.atlassian.clover.util.FilterUtils;
import java.util.StringTokenizer;

public class InclusionUtil {
    public static String[] toArray(String str, String del) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(str, del, false);
        String[] array = new String[tokens.countTokens()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = tokens.nextToken();
        }
        return array;
    }

    public static boolean isIncluded(String source, String[] excludes, String[] includes, boolean defaultValue) {
        if (!(excludes != null && excludes.length != 0 || includes != null && includes.length != 0)) {
            return defaultValue;
        }
        return InclusionUtil.included(source, includes) && !InclusionUtil.excluded(source, excludes);
    }

    public static boolean excluded(String source, String[] excludes) {
        if (excludes == null || excludes.length == 0) {
            return false;
        }
        for (String exclude : excludes) {
            if (!FilterUtils.matchPath(exclude, source, true)) continue;
            return true;
        }
        return false;
    }

    public static boolean included(String source, String[] includes) {
        if (includes == null || includes.length == 0) {
            return true;
        }
        for (String include : includes) {
            if (!FilterUtils.matchPath(include, source, true)) continue;
            return true;
        }
        return false;
    }
}

