/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.util;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.ErrorReportSubmitter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class BlameClover
extends ErrorReportSubmitter {
    private static final String PROJECT_ID = "11772";
    private static final String TICKET_TYPE_BUG = "1";
    private static final String CIJ_COMPONENT = "12941";
    private static final int MAX_URI_LENGTH = 4096;
    private final String bugUrl;

    public String getReportActionText() {
        return "Create error report in the OpenClover online issue tracker";
    }

    public SubmittedReportInfo submit(IdeaLoggingEvent[] events, Component parentComponent) {
        StringBuilder description = new StringBuilder();
        for (IdeaLoggingEvent ideaLoggingEvent : events) {
            description.append(ideaLoggingEvent.getMessage());
            description.append("\n");
            description.append(ideaLoggingEvent.getThrowableText());
            description.append("\n");
        }
        BrowserUtil.browse((String)this.getBugWithDescriptionUrl(description.toString()));
        return new SubmittedReportInfo(null, "JIRA ticket", SubmittedReportInfo.SubmissionStatus.NEW_ISSUE);
    }

    public BlameClover() {
        String environment;
        String rawEnvironment = "Java version=" + System.getProperty("java.version") + ", Java vendor=" + System.getProperty("java.vendor") + ", OS name=" + System.getProperty("os.name") + ", OS architecture=" + System.getProperty("os.arch") + ", IDEA build number=" + this.getIdeaBuild() + "\nPlugin release=" + "4.5.1";
        try {
            environment = URLEncoder.encode(rawEnvironment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            environment = "";
            Logger.getInstance((String)BlameClover.class.getName()).info((Throwable)e);
        }
        this.bugUrl = "https://github.com/openclover/clover/issues?pid=11772&issuetype=1&components=12941&environment=" + environment;
    }

    protected String getIdeaBuild() {
        return ApplicationInfo.getInstance().getBuild().toString();
    }

    String getBugWithDescriptionUrl(String description) {
        String urlStart = this.bugUrl + "&description=";
        int charsLeft = 4096 - urlStart.length();
        return urlStart + this.getBoundedEncodedString(description, charsLeft);
    }

    String getBoundedEncodedString(String description, int maxLen) {
        try {
            String encoded = URLEncoder.encode(description, "UTF-8");
            while (encoded.length() > maxLen) {
                int lastNewline = description.lastIndexOf(10);
                if (lastNewline == -1) {
                    return "";
                }
                description = description.substring(0, lastNewline);
                encoded = URLEncoder.encode(description, "UTF-8");
            }
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

