/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.treetables;

import com.atlassian.clover.idea.coverageview.table.ComplexityColumnInfo;
import com.atlassian.clover.idea.coverageview.table.CoverageColumnInfo;
import com.atlassian.clover.idea.coverageview.table.LOCColumnInfo;
import com.atlassian.clover.idea.coverageview.table.ProjectTreeColumnInfo;
import com.atlassian.clover.idea.coverageview.table.UncoveredColumnInfo;
import com.atlassian.clover.idea.testexplorer.ClassTreeColumnInfo;
import com.atlassian.clover.idea.testexplorer.ContribCoverageColumnInfo;
import com.atlassian.clover.idea.testexplorer.TestExecutionTimeColumnInfo;
import com.atlassian.clover.idea.testexplorer.TestMessageColumnInfo;
import com.atlassian.clover.idea.testexplorer.TestStartedColumnInfo;
import com.atlassian.clover.idea.testexplorer.TestStatusColumnInfo;
import com.atlassian.clover.idea.testexplorer.TestTreeColumnInfo;
import com.atlassian.clover.idea.testexplorer.UniqueCoverageColumnInfo;
import com.atlassian.clover.idea.treetables.ModelSorter;
import com.atlassian.clover.idea.treetables.SortableListTreeTableModelOnColumns;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class TreeTableModelFactory {
    private static final ColumnInfo[] COVERAGE_COLUMN_INFOS = new ColumnInfo[]{new ProjectTreeColumnInfo(), new CoverageColumnInfo(), new ComplexityColumnInfo(), new LOCColumnInfo(), new UncoveredColumnInfo()};
    private static final ColumnInfo[] TEST_CASE_INFO_COLUMN_INFOS = new ColumnInfo[]{new ClassTreeColumnInfo(), new ContribCoverageColumnInfo(), new UniqueCoverageColumnInfo()};
    private static final ColumnInfo[] TEST_CASES_COLUMN_INFOS = new ColumnInfo[]{new TestTreeColumnInfo(), new TestStartedColumnInfo(), new TestStatusColumnInfo(), new TestExecutionTimeColumnInfo(), new ContribCoverageColumnInfo(), new UniqueCoverageColumnInfo(), new TestMessageColumnInfo()};

    public static SortableListTreeTableModelOnColumns getTestCasesTreeTableModel(TreeNode treeNode) {
        return TreeTableModelFactory.getSortableListTreeTableModelOnColumns(treeNode, TEST_CASES_COLUMN_INFOS);
    }

    public static SortableListTreeTableModelOnColumns getCoverageTreeTableModel(TreeNode treeNode) {
        return TreeTableModelFactory.getSortableListTreeTableModelOnColumns(treeNode, COVERAGE_COLUMN_INFOS);
    }

    public static SortableListTreeTableModelOnColumns getTestCaseInfoTreeTableModel(DefaultMutableTreeNode treeNode) {
        return TreeTableModelFactory.getSortableListTreeTableModelOnColumns(treeNode, TEST_CASE_INFO_COLUMN_INFOS);
    }

    public static SortableListTreeTableModelOnColumns getSortableListTreeTableModelOnColumns(TreeNode treeNode, ColumnInfo[] columnInfos) {
        ModelSorter modelSorter = new ModelSorter(columnInfos);
        return new SortableListTreeTableModelOnColumns(treeNode, columnInfos, modelSorter);
    }

    public static JTree retrieveJTree(Component potentialTreeTableView) {
        try {
            Method getTree = potentialTreeTableView.getClass().getMethod("getTree", new Class[0]);
            Object o = getTree.invoke((Object)potentialTreeTableView, new Object[0]);
            return o instanceof JTree ? (JTree)o : null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

