/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.treetables;

import com.intellij.util.ui.ColumnInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.tree.TreeNode;

public class ModelSorter {
    private final int SORT_ASCENDING = 1;
    private final int SORT_DESCENDING = 2;
    private int sortingType = 1;
    private int sortedColumnIndex = -1;
    private final ColumnInfo[] columns;

    public ModelSorter(ColumnInfo[] columnInfos) {
        this.columns = columnInfos;
    }

    public void sortNodes(List<? extends TreeNode> nodes) {
        if (this.sortedColumnIndex < 0 || this.sortedColumnIndex >= this.columns.length) {
            return;
        }
        final Comparator<Object> columnComparator = this.columns[this.sortedColumnIndex].getComparator();
        if (columnComparator == null) {
            return;
        }
        Comparator<Object> actualComparator = this.sortingType == 1 ? columnComparator : new Comparator<TreeNode>(){

            @Override
            public int compare(TreeNode o1, TreeNode o2) {
                return columnComparator.compare(o2, o1);
            }
        };
        Collections.sort(nodes, actualComparator);
    }

    public int getSortingType() {
        return this.sortingType;
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public void sortByColumn(int sortBy) {
        if (this.sortedColumnIndex == sortBy) {
            this.sortingType = this.sortingType == 1 ? 2 : 1;
        } else {
            this.sortingType = 1;
            this.sortedColumnIndex = sortBy;
        }
    }
}

