/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.idea.testexplorer.AbstractTestCaseNodeComparator;
import com.atlassian.clover.idea.treetables.AbstractColumnInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.util.Formatting;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;

public class TestExecutionTimeColumnInfo
extends AbstractColumnInfo<String> {
    private static final Comparator<DefaultMutableTreeNode> COMPARATOR = new AbstractTestCaseNodeComparator(){

        @Override
        int compare(TestCaseInfo tci1, TestCaseInfo tci2) {
            return Double.compare(tci1.getDuration(), tci2.getDuration());
        }
    };

    public TestExecutionTimeColumnInfo() {
        super("Time", RALIGN_CELL_RENDERER);
    }

    public String valueOf(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof TestCaseInfo) {
            TestCaseInfo tci = (TestCaseInfo)userObject;
            return Formatting.format3d(tci.getDuration()) + "s";
        }
        return null;
    }

    public String getPreferredStringValue() {
        return "000 000.000s";
    }

    public Comparator<DefaultMutableTreeNode> getComparator() {
        return COMPARATOR;
    }
}

