/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.testexplorer;

import com.atlassian.clover.BitSetCoverageProvider;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.idea.testexplorer.CoverageDataHolder;
import com.atlassian.clover.idea.testexplorer.SimplePackageFragment;
import com.atlassian.clover.idea.treetables.SortableListTreeTableModelOnColumns;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

class CoverageContributionTreeBuilder {
    private final SortableListTreeTableModelOnColumns tableModel;
    private final DefaultMutableTreeNode rootNode;

    public CoverageContributionTreeBuilder(DefaultMutableTreeNode rootNode, SortableListTreeTableModelOnColumns tableModel) {
        this.rootNode = rootNode;
        this.tableModel = tableModel;
    }

    void processClassesFor(CloverDatabase currentDatabase, TestCaseInfo testCaseInfo, boolean flattenPackages) {
        if (currentDatabase == null) {
            return;
        }
        FullProjectInfo appOnlyProject = currentDatabase.getAppOnlyModel();
        CoverageData data = currentDatabase.getCoverageData();
        final BitSetCoverageProvider testDataProvider = new BitSetCoverageProvider(data.getHitsFor(testCaseInfo), data);
        final BitSetCoverageProvider uniqueTestDataProvider = new BitSetCoverageProvider(currentDatabase.getCoverageData().getUniqueHitsFor(testCaseInfo), data);
        final HashMap<FullPackageInfo, DefaultMutableTreeNode> packageMapping = Maps.newHashMap();
        appOnlyProject.getClasses(new HasMetricsFilter(){

            @Override
            public boolean accept(HasMetrics hm) {
                FullClassInfo classInfo = (FullClassInfo)hm;
                FullClassInfo classInfoCopy = classInfo.copy((FullFileInfo)classInfo.getContainingFile(), HasMetricsFilter.ACCEPT_ALL);
                classInfoCopy.setDataProvider(testDataProvider);
                if (classInfoCopy.getMetrics().getNumCoveredElements() > 0) {
                    FullPackageInfo packageInfo = (FullPackageInfo)classInfo.getPackage();
                    DefaultMutableTreeNode pkgNode = (DefaultMutableTreeNode)packageMapping.get(packageInfo);
                    if (pkgNode == null) {
                        pkgNode = new DefaultMutableTreeNode(packageInfo);
                        packageMapping.put(packageInfo, pkgNode);
                    }
                    CoverageDataHolder classCoverage = new CoverageDataHolder(classInfo);
                    DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(classCoverage);
                    pkgNode.add(classNode);
                    ArrayList<DefaultMutableTreeNode> methodNodes = Lists.newArrayList();
                    classCoverage.setCoverage(classInfoCopy.getMetrics().getPcCoveredElements());
                    for (MethodInfo methodInfo : classInfoCopy.getMethods()) {
                        FullMethodInfo methodInfo2 = (FullMethodInfo)methodInfo;
                        if (methodInfo2.getHitCount() <= 0) continue;
                        float methodCoverage = methodInfo2.isEmpty() ? -1.0f : methodInfo2.getMetrics().getPcCoveredElements();
                        methodInfo2.setDataProvider(uniqueTestDataProvider);
                        float methodUniqueCoverage = methodInfo2.getMetrics().getPcCoveredElements();
                        methodInfo2.setDataProvider(null);
                        CoverageDataHolder methodCoverageData = new CoverageDataHolder(methodInfo2, methodCoverage, methodUniqueCoverage);
                        methodNodes.add(new DefaultMutableTreeNode(methodCoverageData));
                    }
                    CoverageContributionTreeBuilder.this.tableModel.sortNodes(methodNodes);
                    for (DefaultMutableTreeNode defaultMutableTreeNode : methodNodes) {
                        classNode.add(defaultMutableTreeNode);
                    }
                    classInfoCopy.setDataProvider(uniqueTestDataProvider);
                    classCoverage.setUniqueCoverage(classInfoCopy.getMetrics().getPcCoveredElements());
                }
                return false;
            }
        });
        if (flattenPackages) {
            for (DefaultMutableTreeNode pkgNode : packageMapping.values()) {
                this.rootNode.add(pkgNode);
            }
        } else {
            new PackageTreeBuilder(packageMapping).fillTree(this.rootNode);
        }
    }

    private static class PackageTreeBuilder {
        private final SimplePackageFragment root = new SimplePackageFragment("");
        private final Map<FullPackageInfo, DefaultMutableTreeNode> flatTree;

        PackageTreeBuilder(Map<FullPackageInfo, DefaultMutableTreeNode> flatTree) {
            this.flatTree = flatTree;
            for (DefaultMutableTreeNode pkgNode : flatTree.values()) {
                FullPackageInfo packageInfo = (FullPackageInfo)pkgNode.getUserObject();
                this.addPackageToTree(packageInfo);
            }
        }

        private void addPackageToTree(FullPackageInfo packageInfo) {
            String pkgFQName = packageInfo.getName();
            String[] nameParts = pkgFQName.split("\\.");
            SimplePackageFragment parent = this.root;
            for (String namePart : nameParts) {
                SimplePackageFragment fragment = parent.getChild(namePart);
                if (fragment == null) {
                    fragment = parent.add(namePart);
                }
                parent = fragment;
            }
            parent.setConcretePackage(packageInfo);
        }

        void fillTree(DefaultMutableTreeNode rootNode) {
            this.copy(rootNode, this.root);
        }

        void copy(DefaultMutableTreeNode toNode, SimplePackageFragment fromNode) {
            for (SimplePackageFragment fragment : fromNode.getChildren()) {
                DefaultMutableTreeNode pkgNode = new DefaultMutableTreeNode(fragment);
                this.copy(pkgNode, fragment);
                toNode.add(pkgNode);
            }
            FullPackageInfo packageInfo = fromNode.getConcretePackage();
            if (packageInfo != null) {
                DefaultMutableTreeNode origNode = this.flatTree.get(packageInfo);
                while (!origNode.isLeaf()) {
                    toNode.add((MutableTreeNode)origNode.getChildAt(0));
                }
            }
            fromNode.cleanup();
        }
    }
}

