/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.treemap;

import clover.net.sf.jtreemap.swing.JTreeMap;
import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.Value;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.idea.report.treemap.ClassInfoValue;
import com.atlassian.clover.idea.util.ui.ScrollUtil;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class GoToSourceMouseListener
extends MouseAdapter {
    private final JTreeMap treeMap;
    private final Project project;

    public GoToSourceMouseListener(Project project, JTreeMap treeMap) {
        this.project = project;
        this.treeMap = treeMap;
    }

    private ClassInfoValue getActiveClassInfoValue() {
        Value value;
        TreeMapNode node = this.treeMap.getActiveLeaf();
        if (node != null && (value = node.getValue()) instanceof ClassInfoValue) {
            return (ClassInfoValue)value;
        }
        return null;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processEvent(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processEvent(e);
    }

    private void processEvent(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        ClassInfoValue classInfoValue = this.getActiveClassInfoValue();
        if (classInfoValue != null) {
            JPopupMenu menu = new JPopupMenu();
            final FullClassInfo classInfo = classInfoValue.getClassInfo();
            BlockMetrics classMetrics = classInfo.getMetrics();
            String info = "covered " + classMetrics.getNumCoveredElements() + " / " + classMetrics.getNumElements() + " elements";
            JLabel label = new JLabel("<html><b><center>" + classInfo.getName() + "</center></b><small>" + info);
            menu.add(label);
            menu.addSeparator();
            JMenuItem menuItem = menu.add("Jump to source");
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScrollUtil.scrollToSourceRegion(GoToSourceMouseListener.this.project, classInfo);
                }
            });
            menu.show(e.getComponent(), e.getX(), e.getY());
        }
    }
}

