/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.cloud;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.idea.HasMetricsListener;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.coverage.CoverageManager;
import com.atlassian.clover.idea.util.vfs.DummyVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import org.openclover.util.Lists;

public class CloudVirtualFile
extends DummyVirtualFile {
    private static final Key<CloudVirtualFile> FILE_KEY = Key.create((String)CloudVirtualFile.class.getName());
    private final CoverageManager coverageManager;
    private HasMetrics currentlySelectedElement;
    private final Collection<HasMetricsListener> listeners = Lists.newArrayList();

    private CloudVirtualFile(Project project) {
        super("Cloud Report");
        this.coverageManager = ProjectPlugin.getPlugin(project).getCoverageManager();
    }

    public CoverageManager getCoverageManager() {
        return this.coverageManager;
    }

    public static CloudVirtualFile getInstance(Project project) {
        CloudVirtualFile vf = (CloudVirtualFile)((Object)project.getUserData(FILE_KEY));
        if (vf == null) {
            vf = new CloudVirtualFile(project);
            project.putUserData(FILE_KEY, (Object)vf);
        }
        return vf;
    }

    public void addHasMetricsListener(HasMetricsListener listener) {
        this.listeners.add(listener);
    }

    public void removeHasMetricsListener(HasMetricsListener listener) {
        this.listeners.remove(listener);
    }

    private void notify(HasMetrics metrics) {
        for (HasMetricsListener listener : this.listeners) {
            listener.valueChanged(metrics);
        }
    }

    public synchronized void setSelectedElement(HasMetrics element) {
        this.currentlySelectedElement = element;
        this.notify(element);
    }

    public synchronized HasMetrics getSelectedElement() {
        return this.currentlySelectedElement;
    }
}

