/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report.cloud;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.idea.coverage.BaseCoverageNodeViewer;
import com.atlassian.clover.idea.coverage.CoverageNodeViewer;
import com.atlassian.clover.idea.report.cloud.ClassHyperlinkListener;
import com.atlassian.clover.idea.report.cloud.CloudEditorController;
import com.atlassian.clover.idea.report.cloud.CloudReportView;
import com.atlassian.clover.idea.report.cloud.CloudVirtualFile;
import com.atlassian.clover.idea.util.vfs.DummyFileEditor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.VerticalBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudEditor
extends DummyFileEditor
implements CloudReportView,
DataProvider {
    private final JEditorPane riskEditorPane;
    private final JEditorPane winsEditorPane;
    private final JLabel subjectLabel = new JLabel();
    private final CoverageNodeViewer nodeViewer;
    private final JComponent rootComponent;
    private final CloudEditorController controller;

    public CloudEditor(Project project, CloudVirtualFile virtualFile) {
        this.controller = new CloudEditorController(project, virtualFile, this);
        this.riskEditorPane = CloudEditor.createEditorPane(project);
        this.winsEditorPane = CloudEditor.createEditorPane(project);
        JTabbedPane tabs = new JTabbedPane();
        tabs.add("Risks", new JScrollPane(this.riskEditorPane));
        tabs.add("Quick Wins", new JScrollPane(this.winsEditorPane));
        VerticalBox topComponent = new VerticalBox();
        topComponent.add(this.createCtrlPane());
        this.nodeViewer = new CoverageNodeViewer();
        this.nodeViewer.setTestMethodsVisible(false);
        topComponent.add(this.nodeViewer.getPane());
        this.rootComponent = new DataAwarePanel(new BorderLayout());
        this.rootComponent.add((Component)topComponent, "North");
        this.rootComponent.add((Component)tabs, "Center");
        this.controller.update(virtualFile.getCoverageManager().getCoverage());
    }

    private static JEditorPane createEditorPane(Project project) {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.addHyperlinkListener(new ClassHyperlinkListener(project));
        return editorPane;
    }

    private JPanel createCtrlPane() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Cloud report for:"));
        this.subjectLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 5, 3));
        panel.add((Component)this.subjectLabel, "Center");
        panel.add((Component)this.createActionPanel(), "East");
        return panel;
    }

    private JPanel createActionPanel() {
        JPanel panel = new JPanel();
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup cloudReportProjectGroup = (ActionGroup)actionManager.getAction("CloverPlugin.CloudReportProjectBar");
        ActionToolbar cloudReportProjectToolbar = actionManager.createActionToolbar("CloudReportProjectToolbar", cloudReportProjectGroup, true);
        ActionGroup cloudReportPackageGroup = (ActionGroup)actionManager.getAction("CloverPlugin.CloudReportPackageBar");
        ActionToolbar cloudReportPackageToolbar = actionManager.createActionToolbar("CloudReportPackageToolbar", cloudReportPackageGroup, true);
        panel.add(cloudReportProjectToolbar.getComponent());
        panel.add(cloudReportPackageToolbar.getComponent());
        return panel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.rootComponent;
    }

    @NotNull
    public String getName() {
        return "CloverCloudEditor";
    }

    @Override
    public void setRisksHtml(String risks) {
        this.riskEditorPane.setText(risks);
    }

    @Override
    public void setWinsHtml(String wins) {
        this.winsEditorPane.setText(wins);
    }

    @Override
    public void setSummaryIcon(Icon icon) {
        this.subjectLabel.setIcon(icon);
    }

    @Override
    public void setSummaryText(String summary) {
        this.subjectLabel.setText(summary);
    }

    @Override
    public void clean() {
        this.riskEditorPane.setText("");
        this.winsEditorPane.setText("");
        this.nodeViewer.clearNode();
        this.subjectLabel.setIcon(null);
        this.subjectLabel.setText("");
    }

    @Override
    public void setSummaryNode(HasMetrics element, BaseCoverageNodeViewer.TestPassInfo testPassInfo) {
        this.nodeViewer.setNode(element, testPassInfo);
    }

    @Override
    public void dispose() {
        this.controller.dispose();
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        return this.controller.getData(dataId);
    }

    private class DataAwarePanel
    extends JComponent
    implements DataProvider {
        public DataAwarePanel(BorderLayout layout) {
            this.setLayout(layout);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            return CloudEditor.this.controller.getData(dataId);
        }
    }
}

