/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.report;

import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.report.AbstractConfigureUI;
import com.atlassian.clover.idea.report.ReportWizard;
import com.atlassian.clover.idea.report.WizardConfig;
import com.atlassian.clover.idea.util.ui.UIUtils;
import com.atlassian.clover.reporters.ShowLambdaFunctions;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ConfigureXmlUI
extends AbstractConfigureUI {
    private JTextArea helpText;
    private JTextField outputFile;
    private JLabel outputFileLabel;
    private JCheckBox includeLineInfo;

    public ConfigureXmlUI(ReportWizard wiz) {
        super(wiz);
        this.initComponents();
        this.initListeners();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.getHelpText(), new GBC(0, 0).setSpan(2, 1).setInsets(5, 5, 5, 5).setAnchor(18).setFill(2));
        this.add((Component)this.getReportTitleLabel(), new GBC(0, 1).setSpan(2, 1).setInsets(5, 5, 5, 5).setFill(2).setAnchor(18));
        this.add((Component)this.getReportTitle(), new GBC(0, 2).setSpan(2, 1).setInsets(0, 5, 5, 5).setFill(2).setAnchor(18).setWeight(0.01, 0.0));
        this.add((Component)this.getOutputFileLabel(), new GBC(0, 3).setSpan(2, 1).setInsets(5, 5, 5, 5).setFill(2).setAnchor(18));
        this.add(UIUtils.wrapWithFileChooser(this.wizard.getDialogWindow(), this.getOutputFile(), 0), new GBC(0, 4).setSpan(2, 1).setInsets(0, 5, 5, 5).setFill(2).setAnchor(18).setWeight(0.01, 0.0));
        this.add((Component)this.getIncludeLineInfo(), new GBC(0, 5).setSpan(2, 1).setInsets(0, 5, 5, 5).setFill(2).setAnchor(18));
        this.add((Component)this.getUseFilters(), new GBC(0, 6).setSpan(2, 1).setFill(2).setInsets(0, 5, 5, 5).setAnchor(18));
        this.add((Component)this.getShowLambdaLabel(), new GBC(0, 7).setFill(2).setInsets(0, 5, 5, 5).setAnchor(17));
        this.add((Component)this.getShowLambdaCombo(), new GBC(1, 7).setFill(2).setInsets(0, 5, 5, 5).setAnchor(17));
        this.add((Component)new JPanel(), new GBC(0, 8).setSpan(2, 1).setFill(3).setWeight(0.0, 0.1));
    }

    @Override
    protected void initListeners() {
        this.getUseFilters().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureXmlUI.this.wizard.refreshState(!ConfigureXmlUI.this.getUseFilters().isSelected());
            }
        });
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("Please specify the report title and the output file. The output file is the file used for the generated report.", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private JTextField getOutputFile() {
        if (this.outputFile == null) {
            this.outputFile = new JTextField(20);
        }
        return this.outputFile;
    }

    private JLabel getOutputFileLabel() {
        if (this.outputFileLabel == null) {
            this.outputFileLabel = new JLabel("Output File:");
            this.outputFileLabel.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        }
        return this.outputFileLabel;
    }

    private JCheckBox getIncludeLineInfo() {
        if (this.includeLineInfo == null) {
            this.includeLineInfo = new JCheckBox("Include line info:");
        }
        return this.includeLineInfo;
    }

    @Override
    public void writeConfig(WizardConfig reportConfig) {
        WizardConfig.XmlReport config = reportConfig.getXmlConfig();
        config.setReportTitle(this.getReportTitle().getText());
        config.setFile(new File(this.getOutputFile().getText()));
        config.setIncludeLineInfo(this.getIncludeLineInfo().isSelected());
        config.setShowLambda(this.getShowLambdaCombo().getSelectedIndex() == 2 ? ShowLambdaFunctions.FIELDS_AND_INLINE : (this.getShowLambdaCombo().getSelectedIndex() == 1 ? ShowLambdaFunctions.FIELDS_ONLY : ShowLambdaFunctions.NONE));
        reportConfig.setUseCurrentFilterSettings(this.getUseFilters().isSelected());
    }

    @Override
    public void readConfig(WizardConfig reportConfig) {
        WizardConfig.XmlReport config = reportConfig.getXmlConfig();
        this.getReportTitle().setText(config.getReportTitle());
        this.getOutputFile().setText(config.getFile().getAbsolutePath());
        this.getIncludeLineInfo().setSelected(config.isIncludeLineInfo());
        this.getShowLambdaCombo().setSelectedIndex(config.getShowLambda().ordinal());
        this.getUseFilters().setSelected(reportConfig.isUseCurrentFilterSettings());
    }

    @Override
    public String validateSettings() {
        String txt = this.getOutputFile().getText();
        if (txt == null || txt.trim().length() == 0) {
            return "Please enter an output file.";
        }
        return null;
    }
}

