/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.projectview;

import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.projectview.PresentationUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;

class PackageElementNodeWrapper
extends PackageElementNode {
    PackageElementNodeWrapper(PackageElementNode orig) {
        super(orig.getProject(), (PackageElement)orig.getValue(), orig.getSettings());
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        PsiPackage pkg = ((PackageElement)this.getValue()).getPackage();
        IProjectPlugin plugin = ProjectPlugin.getPlugin(this.getProject());
        if (plugin != null && plugin.getFeatureManager().isFeatureEnabled("clover-icondecoration")) {
            PresentationUtil.overlayPackagePresentation(presentation, (PsiElement)pkg);
        }
    }

    static boolean canAnnotate(AbstractTreeNode abstractNode) {
        if (!(abstractNode instanceof PackageElementNode)) {
            return false;
        }
        PackageElementNode node = (PackageElementNode)abstractNode;
        PackageElement element = (PackageElement)node.getValue();
        return !element.isLibraryElement();
    }
}

