/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.junit;

import com.atlassian.clover.idea.junit.config.TestOptimizationGlobalSettings;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NoTestsFoundNotification
extends DialogWrapper {
    private JPanel contentPane;
    private JCheckBox displayThisDialogCheckBox;
    private JCheckBox notifyByBalloonCheckBox;
    private JLabel messageLabel;
    private final TestOptimizationGlobalSettings settings;

    public NoTestsFoundNotification(TestOptimizationGlobalSettings settings) {
        super(false);
        this.settings = settings;
        this.$$$setupUI$$$();
        this.setTitle("Clover Test Optimization");
        this.displayThisDialogCheckBox.setSelected(settings.isShowAllTestsOptimizedOutDialog());
        this.notifyByBalloonCheckBox.setSelected(settings.isShowAllTestsOptimizedOutBalloon());
        this.init();
    }

    public static void showNotificationDialog() {
        TestOptimizationGlobalSettings togs = TestOptimizationGlobalSettings.getInstance();
        new NoTestsFoundNotification(togs).show();
    }

    public static void showNotificationBalloon() {
        Project[] projects;
        Project guessedProject = null;
        AsyncResult result = DataManager.getInstance().getDataContextFromFocus();
        if (result != null && result.getResult() != null) {
            guessedProject = (Project)DataKeys.PROJECT.getData((DataContext)result.getResult());
        }
        if (guessedProject == null && (projects = ProjectManager.getInstance().getOpenProjects()).length == 1) {
            guessedProject = projects[0];
        }
        if (guessedProject != null) {
            ToolWindowManager.getInstance(guessedProject).notifyByBalloon("Cloverage", MessageType.INFO, CloverIdeaPluginMessages.getString("launch.optimized.notestsfound"));
        }
    }

    public static void showNotifications() {
        TestOptimizationGlobalSettings togs = TestOptimizationGlobalSettings.getInstance();
        if (togs.isShowAllTestsOptimizedOutBalloon()) {
            NoTestsFoundNotification.showNotificationBalloon();
        }
        if (togs.isShowAllTestsOptimizedOutDialog()) {
            NoTestsFoundNotification.showNotificationDialog();
        }
    }

    protected void doOKAction() {
        this.settings.setShowAllTestsOptimizedOutDialog(this.displayThisDialogCheckBox.isSelected());
        this.settings.setShowAllTestsOptimizedOutBalloon(this.notifyByBalloonCheckBox.isSelected());
        super.doOKAction();
    }

    private void createUIComponents() {
        this.messageLabel = new JLabel(CloverIdeaPluginMessages.getString("launch.optimized.notestsfound"));
        this.messageLabel.setIcon(Messages.getInformationIcon());
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    private void $$$setupUI$$$() {
        this.createUIComponents();
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new FormLayout("fill:max(d;4px):noGrow,left:18dlu:noGrow,fill:420px:noGrow", "center:max(d;4px):noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow,top:4dlu:noGrow,center:max(d;4px):noGrow"));
        CellConstraints cc = new CellConstraints();
        this.contentPane.add((Component)this.messageLabel, cc.xyw(1, 1, 3));
        JLabel label1 = new JLabel();
        label1.setText("Next time this happens:");
        this.contentPane.add((Component)label1, cc.xy(3, 2));
        this.displayThisDialogCheckBox = new JCheckBox();
        this.displayThisDialogCheckBox.setText("Display this dialog");
        this.contentPane.add((Component)this.displayThisDialogCheckBox, cc.xy(3, 4));
        this.notifyByBalloonCheckBox = new JCheckBox();
        this.notifyByBalloonCheckBox.setText("Notify by Balloon");
        this.contentPane.add((Component)this.notifyByBalloonCheckBox, cc.xy(3, 6));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

