/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.junit;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.junit.FileBasedJUnitClassListProcessor;
import com.atlassian.clover.idea.junit.SavingsReporter;
import com.atlassian.clover.idea.junit.SocketBasedJUnitClassListProcessor;
import com.atlassian.clover.idea.junit.config.OptimizedConfigurationSettings;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.idea.util.ui.MessageDialogs;
import com.atlassian.clover.optimization.OptimizationSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindowManager;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitOptimizingProgramRunnerBase
implements SavingsReporter {
    private static final String JUNIT_CONFIGURATION_ID = "JUnit";
    private static final String ANDROID_JUNIT_CONFIGURATION_ID = "AndroidJUnit";
    private static final Key<Boolean> EXPLICIT_COVERAGE_LOAD_REQUEST_KEY = new Key("com.cenqua.clover.explicit_coverage_load_request");

    public static boolean wasExplicitCoverageLoadRequested(ProcessHandler processHandler) {
        Boolean requested = (Boolean)processHandler.getUserData(EXPLICIT_COVERAGE_LOAD_REQUEST_KEY);
        return requested != null && requested != false;
    }

    @NotNull
    String getJUnitConfigurationId() {
        return JUNIT_CONFIGURATION_ID;
    }

    @NotNull
    String getAndroidJunitConfigurationId() {
        return ANDROID_JUNIT_CONFIGURATION_ID;
    }

    Key<Boolean> getExplicitCoverageLoadRequestKey() {
        return EXPLICIT_COVERAGE_LOAD_REQUEST_KEY;
    }

    boolean checkExecutionEnvironment(@NotNull ExecutionEnvironment executionEnvironment) {
        RunConfiguration runConfiguration;
        String configuratonId;
        if (executionEnvironment.getRunProfile() instanceof RunConfiguration && (JUNIT_CONFIGURATION_ID.equals(configuratonId = (runConfiguration = (RunConfiguration)executionEnvironment.getRunProfile()).getType().getId()) || ANDROID_JUNIT_CONFIGURATION_ID.equals(configuratonId))) {
            return true;
        }
        MessageDialogs.showInfoMessage(null, CloverIdeaPluginMessages.getString("launch.optimized.junitonly"), "Clover Test Optimization");
        return false;
    }

    void patchImpl(JavaParameters javaParameters, RunProfile runProfile, OptimizedConfigurationSettings configurationSettings) throws ExecutionException {
        if (!(runProfile instanceof RunConfiguration)) {
            Project[] projects;
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                ToolWindowManager.getInstance((Project)project).notifyByBalloon("Cloverage", MessageType.ERROR, "Cannot retrieve project for current run configuration");
                this.reportSavings(project, "Cannot retrieve project for current run configuration. No Clover test optimization. ");
            }
            return;
        }
        Project currentProject = ((RunConfiguration)runProfile).getProject();
        String configurationId = ((RunConfiguration)runProfile).getType().getId();
        if (!JUNIT_CONFIGURATION_ID.equals(configurationId) && !ANDROID_JUNIT_CONFIGURATION_ID.equals(configurationId)) {
            Logger.getInstance().warn("Run profile is not a recognized JUnit or Android JUnit configuration");
            this.reportSavings(currentProject, "Run profile is not a recognized JUnit or Android JUnit configuration. No Clover test optimization.");
            return;
        }
        File tmpFile = this.retrieveTmpFile(javaParameters);
        if (tmpFile != null) {
            int jUnitSychSocket = this.retrieveJUnitSychSocket(javaParameters);
            if (jUnitSychSocket == -1) {
                FileBasedJUnitClassListProcessor processor = new FileBasedJUnitClassListProcessor(this, tmpFile, currentProject, configurationSettings);
                File newFile = processor.processWhenFileNotEmpty();
                if (newFile != null) {
                    JUnitOptimizingProgramRunnerBase.replaceTmpFile(javaParameters, newFile);
                }
            } else {
                SocketBasedJUnitClassListProcessor processor = new SocketBasedJUnitClassListProcessor(this, tmpFile, currentProject, configurationSettings);
                int newSocket = processor.processWhenSocketReady(jUnitSychSocket);
                this.replaceJUnitSynchSocket(javaParameters, newSocket);
            }
        }
    }

    void replaceJUnitSynchSocket(@NotNull JavaParameters javaParameters, int newSocket) {
        String socket = this.findSocketParamValue(javaParameters);
        javaParameters.getProgramParametersList().replaceOrAppend("-socket" + socket, "-socket" + newSocket);
    }

    @Override
    public void reportSavings(@Nullable Project project, @Nullable OptimizationSession optimizationSession) {
        if (project != null && optimizationSession != null) {
            this.reportSavings(project, optimizationSession.getPlainSummary());
        }
    }

    @Nullable
    File retrieveTmpFile(@NotNull JavaParameters javaParameters) {
        String path = JUnitOptimizingProgramRunnerBase.findTmpFileName(javaParameters);
        if (path != null) {
            File tmpFile = new File(path);
            if (tmpFile.exists() && tmpFile.canRead() && tmpFile.canWrite()) {
                return tmpFile;
            }
            Logger.getInstance().warn("Cannot access JUnit temporary file at " + path);
            return null;
        }
        return null;
    }

    int retrieveJUnitSychSocket(@NotNull JavaParameters javaParameters) {
        String param = this.findSocketParamValue(javaParameters);
        return param == null ? -1 : Integer.parseInt(param);
    }

    private void reportSavings(final @NotNull Project project, final @NotNull String optimizationMessage) {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    JUnitOptimizingProgramRunnerBase.this.reportSavings(project, optimizationMessage);
                }
            });
        } else {
            String windowId = ExecutorRegistry.getInstance().getExecutorById("Clover Test Optimization").getToolWindowId();
            ToolWindowManager.getInstance((Project)project).notifyByBalloon(windowId, MessageType.INFO, optimizationMessage, CloverIcons.CLOVER_BIG, null);
        }
    }

    @Nullable
    private String findSocketParamValue(@NotNull JavaParameters javaParameters) {
        Pattern pattern = Pattern.compile("^-socket(\\d+)$");
        for (String param : javaParameters.getProgramParametersList().getList()) {
            Matcher matcher = pattern.matcher(param);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return null;
    }

    private static void replaceTmpFile(JavaParameters javaParameters, File newFile) {
        String file = JUnitOptimizingProgramRunnerBase.findTmpFileName(javaParameters);
        javaParameters.getProgramParametersList().replaceOrAppend("@" + file, "@" + newFile.getPath());
    }

    private static String findTmpFileName(@NotNull JavaParameters javaParameters) {
        for (String param : javaParameters.getProgramParametersList().getList()) {
            if (param.length() <= 1 || param.charAt(0) != '@' || param.charAt(1) != '/') continue;
            return param.substring(1);
        }
        return null;
    }
}

