/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.feature;

import com.atlassian.clover.idea.feature.Category;
import com.atlassian.clover.idea.feature.CategoryEvent;
import com.atlassian.clover.idea.feature.CategoryListener;
import com.atlassian.clover.idea.feature.FeatureEvent;
import com.atlassian.clover.idea.feature.FeatureListener;
import java.util.Collections;
import java.util.List;
import org.openclover.util.Lists;

public class FeatureTreeNode
implements CategoryListener {
    private final Category category;
    private final List<FeatureTreeNode> children = Lists.newArrayList();
    private FeatureTreeNode parent = null;
    private boolean featureEnabled = false;
    private final List<FeatureListener> listeners = Lists.newArrayList();

    public FeatureTreeNode(Category c) {
        this.category = c;
        this.category.addCategoryListener(this);
        this.featureEnabled = this.isFeatureEnabled();
    }

    public void addChild(FeatureTreeNode n) {
        if (!this.children.contains(n)) {
            this.children.add(n);
            n.setParent(this);
        }
    }

    public List<FeatureTreeNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addFeatureListener(FeatureListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeFeatureListener(FeatureListener l) {
        this.listeners.remove(l);
    }

    private void setParent(FeatureTreeNode n) {
        this.parent = n;
        this.featureEnabled = this.isFeatureEnabled();
    }

    @Override
    public void categoryStateChanged(CategoryEvent evt) {
        this.update(evt.getSource());
    }

    public String getCategoryName() {
        return this.category.getName();
    }

    public Category getCategory() {
        return this.category;
    }

    public String getName() {
        String name = this.getCategoryName();
        if (this.parent != null) {
            name = this.parent.getName() + "-" + name;
        }
        return name;
    }

    protected void update(Object source) {
        if (this.featureEnabled == this.isFeatureEnabled()) {
            return;
        }
        this.featureEnabled = !this.featureEnabled;
        FeatureEvent evt = new FeatureEvent(source, this.featureEnabled, this.getName());
        for (FeatureListener listener : Lists.newArrayList(this.listeners)) {
            listener.featureStateChanged(evt);
        }
        for (FeatureTreeNode child : this.children) {
            child.update(source);
        }
    }

    public boolean isFeatureEnabled() {
        if (this.category.isEnabled()) {
            if (this.parent != null) {
                return this.parent.isFeatureEnabled();
            }
            return true;
        }
        return false;
    }
}

