/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.feature;

import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.feature.AbstractCategory;
import com.atlassian.clover.idea.feature.CategoryEvent;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Method;

public class ConfigPropertyCategory
extends AbstractCategory
implements ConfigChangeListener {
    private final String key;
    private final CloverPluginConfig data;

    public ConfigPropertyCategory(String categoryName, String configKey, CloverPluginConfig configData) {
        super(categoryName);
        this.key = configKey;
        this.data = configData;
        this.data.addConfigChangeListener(this);
    }

    @Override
    public void setEnabled(boolean b) {
        if (b != this.isEnabled()) {
            this.data.putProperty(this.key, b);
            this.data.notifyListeners();
        }
    }

    @Override
    public boolean isEnabled() {
        try {
            String methodName = "is" + Character.toUpperCase(this.key.charAt(0)) + this.key.substring(1);
            Method getter = this.data.getClass().getMethod(methodName, new Class[0]);
            Object obj = getter.invoke((Object)this.data, new Object[0]);
            return (Boolean)obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange(this.key)) {
            boolean enabled = false;
            PropertyChangeEvent pcEvent = evt.getPropertyChange(this.key);
            Object val = pcEvent.getNewValue();
            if (val != null && val instanceof Boolean) {
                enabled = (Boolean)val;
            }
            CategoryEvent cevt = new CategoryEvent(this, this.getName(), enabled);
            this.fireCategoryEvent(cevt);
        }
    }
}

