/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.feature;

import com.atlassian.clover.idea.feature.Category;
import com.atlassian.clover.idea.feature.CategoryEvent;
import com.atlassian.clover.idea.feature.CategoryListener;
import java.util.List;
import org.openclover.util.Lists;

public abstract class AbstractCategory
implements Category {
    private final String name;
    private final List<CategoryListener> listeners = Lists.newArrayList();

    public AbstractCategory(String categoryName) {
        this.name = categoryName;
    }

    @Override
    public void addCategoryListener(CategoryListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeCategoryListener(CategoryListener l) {
        this.listeners.remove(l);
    }

    protected void fireCategoryEvent(CategoryEvent evt) {
        for (CategoryListener l : this.listeners) {
            l.categoryStateChanged(evt);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

