/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.idea.coverage.SnapshotFileMutex;
import java.io.File;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openclover.util.Maps;

public class SnapshotFileMutexService
implements SnapshotFileMutex {
    private final Map<File, CountedLock> locks = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockFile(File file) {
        CountedLock countedLock;
        Map<File, CountedLock> map = this.locks;
        synchronized (map) {
            countedLock = this.locks.get(file);
            if (countedLock == null) {
                countedLock = new CountedLock();
                this.locks.put(file, countedLock);
            } else {
                ++countedLock.count;
            }
        }
        countedLock.lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseFile(File file) {
        CountedLock countedLock;
        Map<File, CountedLock> map = this.locks;
        synchronized (map) {
            countedLock = this.locks.get(file);
            if (countedLock == null) {
                throw new IllegalMonitorStateException("Unlocking not locked file " + file.getAbsolutePath());
            }
            if (--countedLock.count == 0) {
                this.locks.remove(file);
            }
        }
        countedLock.lock.unlock();
    }

    int mapSize() {
        return this.locks.size();
    }

    private static class CountedLock {
        private final Lock lock = new ReentrantLock();
        private int count = 1;

        private CountedLock() {
        }
    }
}

