/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.coverage;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.MaskedBitSetCoverageProvider;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.cfg.StorageSize;
import com.atlassian.clover.idea.coverage.BaseCoverageNodeViewer;
import com.atlassian.clover.idea.coverage.CoverageTreeFilter;
import com.atlassian.clover.idea.coverage.ModelUtil;
import com.atlassian.clover.idea.coverage.SnapshotFileMutex;
import com.atlassian.clover.idea.util.ModelScope;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.recorder.PerTestCoverageStrategy;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.CoverageDataProvider;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.PackageFragment;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.registry.metrics.FileMetrics;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.reporters.filters.DefaultTestFilter;
import com.atlassian.clover.util.Formatting;
import com.atlassian.clover.util.Path;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class CoverageTreeModel {
    private static final long MIN_STORAGE_SIZE = 0x1000000L;
    private static final Logger LOG = Logger.getInstance();
    private CloverDatabase db;
    public final Semaphore dbLock = new Semaphore(1);
    private Map<String, PackageFragment> packageFragmentMap;
    private CoverageDataProvider passedOnlyDataCache;
    private DefaultMutableTreeNode mTree;
    private boolean mFragmented;
    private String filterSpec;
    private String mRootName;
    private String mInitString;
    private long mSpan;
    private final Path sourcepath;
    private ModelScope modelScope;
    private boolean loadPerTestData;
    private HasMetricsFilter.Invertable testFilter;
    private final HasMetricsFilter includeFilter;
    private final Project project;
    private static final Comparator<HasMetrics> HASMETRICS_COMPARATOR = new Comparator<HasMetrics>(){

        @Override
        public int compare(HasMetrics o1, HasMetrics o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private LinkedList<CoverageTreeFilter> filters = Lists.newLinkedList();

    public CoverageTreeModel(String rootname, String initString, long span, String filterSpec, boolean fragment, Path sourcepath, ModelScope modelScope, boolean loadPerTestData, HasMetricsFilter.Invertable testFilter, HasMetricsFilter includeFilter, Project project) {
        this.mRootName = rootname;
        this.mInitString = initString;
        this.mSpan = span;
        this.filterSpec = filterSpec;
        this.mFragmented = fragment;
        this.sourcepath = sourcepath;
        this.modelScope = modelScope;
        this.loadPerTestData = loadPerTestData;
        this.project = project;
        this.testFilter = testFilter != null ? testFilter : new DefaultTestFilter();
        this.includeFilter = includeFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoverageTreeModel safeCopy(ProgressIndicator progressIndicator) {
        CoverageTreeModel copy = new CoverageTreeModel(this.mRootName, this.mInitString, this.mSpan, this.filterSpec, this.mFragmented, this.sourcepath, this.modelScope, this.loadPerTestData, this.testFilter, this.includeFilter, this.project);
        try {
            while (!this.dbLock.tryAcquire(500L, TimeUnit.MILLISECONDS)) {
                progressIndicator.checkCanceled();
            }
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        try {
            copy.db = this.db == null ? null : this.db.copyForBackgroundCoverageDataLoad();
            copy.packageFragmentMap = Maps.newHashMap(this.packageFragmentMap);
        }
        finally {
            this.dbLock.release();
        }
        return copy;
    }

    public boolean canLoad() {
        return this.mInitString != null && this.mInitString.length() > 0 && new File(this.mInitString).exists();
    }

    @Nullable
    public CloverDatabase getCloverDatabase() {
        return this.db;
    }

    private static StorageSize calcAvailableStorageSize() {
        long maxHeap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        long maxSize = maxHeap / 4L;
        return new StorageSize(maxSize > 0x1000000L ? maxSize : 0x1000000L);
    }

    public void load(@NotNull ProgressListener progressListener) {
        progressListener.handleProgress("Creating database", 0.0f);
        try {
            this.db = new CloverDatabase(this.mInitString, this.includeFilter, null, this.filterSpec, progressListener);
            this.passedOnlyDataCache = null;
        }
        catch (CloverException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            LOG.info("Problem loading Coverage Data:", e);
            this.mRootName = "Problem loading Coverage Data. Please regenerate.";
        }
        if (this.db != null) {
            progressListener.handleProgress("Building Index", 0.0f);
            this.rebuildPackageTreeIndex();
            this.loadCoverageData(this.loadPerTestData, progressListener);
            if (this.sourcepath != null) {
                progressListener.handleProgress("Resolving coverage data", 0.0f);
                this.db.resolve(this.sourcepath);
            }
        }
        progressListener.handleProgress("Clover Database loaded", 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCoverageData(boolean loadPerTestData, ProgressListener progressListener) {
        Snapshot snapshot;
        this.passedOnlyDataCache = null;
        if (this.db == null) {
            return;
        }
        progressListener.handleProgress("Loading coverage data", 0.0f);
        try {
            this.db.loadCoverageData(this.prepareCoverageDataSpec(loadPerTestData), progressListener);
        }
        catch (CloverException e) {
            LOG.info("Coverage data load failed", e);
            throw new ProcessCanceledException((Throwable)e);
        }
        progressListener.handleProgress("Looking for a test optimization snapshot file", 0.0f);
        SnapshotFileMutex mutex = (SnapshotFileMutex)ServiceManager.getService(SnapshotFileMutex.class);
        File snapshotFile = new File(Snapshot.fileNameForInitString(this.mInitString));
        mutex.lockFile(snapshotFile);
        try {
            snapshot = Snapshot.loadFrom(snapshotFile);
        }
        finally {
            mutex.releaseFile(snapshotFile);
        }
        if (snapshot != null) {
            progressListener.handleProgress("Updating test optimization snapshot file", 0.0f);
            snapshot.updateFor(this.db);
            try {
                mutex.lockFile(snapshot.getLocation());
                snapshot.store();
            }
            catch (IOException e) {
                LOG.warn("Storing tespt optimization snapshot failed, deleting snapshot to prevent wrong optimization", e);
                snapshot.delete();
            }
            finally {
                mutex.releaseFile(snapshot.getLocation());
            }
        }
    }

    public CoverageDataSpec prepareCoverageDataSpec(boolean loadPerTestData) {
        CoverageDataSpec spec = new CoverageDataSpec(this.testFilter, this.computeSpan());
        spec.setLoadPerTestData(loadPerTestData);
        spec.setPerTestStrategy(PerTestCoverageStrategy.SAMPLING);
        spec.setPerTestStorageSize(CoverageTreeModel.calcAvailableStorageSize());
        return spec;
    }

    private long computeSpan() {
        if (this.mSpan != 0L) {
            return this.mSpan;
        }
        long start = CoverageTreeModel.findFirstInstrTime(this.db);
        return start == Long.MAX_VALUE ? 0L : this.db.getRegistry().getVersion() - start;
    }

    public synchronized boolean applyIncludePassedTestCoverageOnlyFilter(boolean includePassedOnly) {
        if (this.db == null) {
            return false;
        }
        if (ModelUtil.isPassedTestsCoverageOnly(this.db) == includePassedOnly) {
            return false;
        }
        CoverageData fullData = this.db.getCoverageData();
        CoverageTreeModel.applyDataProvider(this.db, (CoverageDataProvider)((Object)(includePassedOnly ? new MaskedBitSetCoverageProvider(fullData.getPassOnlyAndIncidentalHits(), fullData, fullData) : fullData)));
        return true;
    }

    private static void applyDataProvider(@NotNull CloverDatabase cloverDatabase, @NotNull CoverageDataProvider provider) {
        cloverDatabase.getFullModel().setDataProvider(provider);
        cloverDatabase.getAppOnlyModel().setDataProvider(provider);
        cloverDatabase.getTestOnlyModel().setDataProvider(provider);
    }

    private static long findFirstInstrTime(@NotNull CloverDatabase db) {
        List instrEvents = db.getRegistry().getInstrHistory();
        long minTime = Long.MAX_VALUE;
        for (Clover2Registry.InstrumentationInfo instrEvent : instrEvents) {
            long ts = instrEvent.getEndTS();
            if (ts >= minTime) continue;
            minTime = ts;
        }
        return minTime;
    }

    public TreePath getEquivPath(TreePath path) {
        try {
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getPathComponent(path.getPathCount() - 1);
            NodeWrapper target = (NodeWrapper)last.getUserObject();
            Enumeration<TreeNode> nodes = this.mTree.breadthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                NodeWrapper wrapper = (NodeWrapper)node.getUserObject();
                if (!target.getId().equals(wrapper.getId())) continue;
                return new TreePath(node.getPath());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    public TreePath getPathForFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            file = file.getCanonicalFile();
            Enumeration<TreeNode> nodes = this.mTree.breadthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                FullFileInfo fileInfo;
                NodeWrapper wrapper;
                HasMetrics hasMetrics;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                Object userObject = node.getUserObject();
                if (!(userObject instanceof NodeWrapper) || !((hasMetrics = (wrapper = (NodeWrapper)userObject).getHasMetrics()) instanceof FullClassInfo) || !file.equals((fileInfo = (FullFileInfo)((FullClassInfo)hasMetrics).getContainingFile()).getPhysicalFile())) continue;
                return new TreePath(node.getPath());
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public TreePath getPathForHasMetrics(HasMetrics hasMetrics) {
        Enumeration<TreeNode> nodes = this.mTree.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            NodeWrapper wrapper;
            HasMetrics nodeHasMetrics;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeWrapper) || !(nodeHasMetrics = (wrapper = (NodeWrapper)userObject).getHasMetrics()).equals(hasMetrics)) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    public void startRegistryUpdate() {
        this.dbLock.acquireUninterruptibly();
    }

    public void registryUpdated() {
        this.dbLock.release();
        this.rebuildPackageTreeIndex();
    }

    public CoverageDataProvider getCachedPassOnlyCoverage() {
        if (this.db == null) {
            return null;
        }
        if (this.passedOnlyDataCache == null) {
            CoverageData fullData = this.db.getCoverageData();
            this.passedOnlyDataCache = new MaskedBitSetCoverageProvider(fullData.getPassOnlyAndIncidentalHits(), fullData, fullData);
        }
        return this.passedOnlyDataCache;
    }

    private BaseCoverageNodeViewer.TestPassInfo calculatePFTestPasses(PackageFragment packageFragment) {
        PackageFragment globalPackageFragment = this.modelScope == ModelScope.ALL_CLASSES ? packageFragment : this.packageFragmentMap.get(packageFragment.getQualifiedName());
        return new BaseCoverageNodeViewer.TestPassInfo(globalPackageFragment.getMetrics());
    }

    private BaseCoverageNodeViewer.TestPassInfo calculateTestPasses(CoverageDataReceptor codeReceptor) {
        Set<TestCaseInfo> hits = this.db.getTestHits(codeReceptor);
        return new BaseCoverageNodeViewer.TestPassInfo(hits);
    }

    private void addFragmentPackageNode(PackageFragment fragmentInfo, DefaultMutableTreeNode parentNode) {
        DefaultMutableTreeNode fragmentNode = new DefaultMutableTreeNode(new NodeWrapper(fragmentInfo.getName(), fragmentInfo, this.calculatePFTestPasses(fragmentInfo)));
        parentNode.add(fragmentNode);
        PackageFragment[] children = fragmentInfo.getChildren();
        Arrays.sort(children, HASMETRICS_COMPARATOR);
        for (PackageFragment aChildren : children) {
            this.addFragmentPackageNode(aChildren, fragmentNode);
        }
        if (fragmentInfo.isConcrete()) {
            this.addClassNodes(fragmentInfo.getConcretePackage().getClasses(), fragmentNode);
        }
    }

    private void addFlatPackageNode(PackageFragment fragmentInfo, DefaultMutableTreeNode parentNode) {
        if (fragmentInfo.isConcrete()) {
            FullPackageInfo concretePackage = fragmentInfo.getConcretePackage();
            DefaultMutableTreeNode fragmentNode = new DefaultMutableTreeNode(new NodeWrapper(concretePackage.getName(), concretePackage, this.calculatePFTestPasses(fragmentInfo)));
            parentNode.add(fragmentNode);
            this.addClassNodes(concretePackage.getClasses(), fragmentNode);
        }
        PackageFragment[] children = fragmentInfo.getChildren();
        Arrays.sort(children, HASMETRICS_COMPARATOR);
        for (PackageFragment aChildren : children) {
            this.addFlatPackageNode(aChildren, parentNode);
        }
    }

    private void addClassNodes(List classes, DefaultMutableTreeNode fragmentNode) {
        FullClassInfo[] classesArray = new FullClassInfo[classes.size()];
        classes.toArray(classesArray);
        Arrays.sort(classesArray, HASMETRICS_COMPARATOR);
        for (FullClassInfo classInfo : classesArray) {
            DefaultMutableTreeNode classNode = new DefaultMutableTreeNode(new NodeWrapper(classInfo.getContainingFile() + ":" + classInfo.getName(), classInfo));
            fragmentNode.add(classNode);
            List<? extends MethodInfo> methods = classInfo.getMethods();
            Collections.sort(methods, HASMETRICS_COMPARATOR);
            for (MethodInfo methodInfo : methods) {
                if (methodInfo.isLambda()) continue;
                classNode.add(new DefaultMutableTreeNode(new NodeWrapper(methodInfo.getContainingFile() + ":" + methodInfo.getContainingClass() + ":" + methodInfo.getName(), methodInfo)));
            }
        }
    }

    private void rebuildPackageTreeIndex() {
        this.packageFragmentMap = Maps.newHashMap();
        for (PackageFragment fragment : this.db.getFullModel().getPackageRoots()) {
            this.indexPackageFragment(fragment);
        }
    }

    private void indexPackageFragment(PackageFragment fragment) {
        this.packageFragmentMap.put(fragment.getQualifiedName(), fragment);
        for (PackageFragment child : fragment.getChildren()) {
            this.indexPackageFragment(child);
        }
    }

    public synchronized void createTree() {
        if (this.db == null) {
            this.mTree = new DefaultMutableTreeNode(this.mRootName, false);
        } else {
            FullProjectInfo projectInfo = ModelUtil.getModel(this.db, this.modelScope);
            this.mTree = new DefaultMutableTreeNode(new NodeWrapper(this.mRootName, projectInfo, new BaseCoverageNodeViewer.TestPassInfo(this.db.getFullModel().getMetrics())));
            PackageFragment[] roots = projectInfo.getPackageRoots();
            Arrays.sort(roots, HASMETRICS_COMPARATOR);
            for (PackageFragment root : roots) {
                if (this.mFragmented) {
                    this.addFragmentPackageNode(root, this.mTree);
                    continue;
                }
                this.addFlatPackageNode(root, this.mTree);
            }
        }
    }

    public synchronized DefaultMutableTreeNode getClassTree(boolean frag, ModelScope modelScope) {
        if (frag != this.mFragmented || this.modelScope != modelScope || this.mTree == null) {
            this.mFragmented = frag;
            this.modelScope = modelScope;
            this.createTree();
            this.applyFilters();
        }
        return this.mTree;
    }

    public static NodeWrapper getNodeForPath(TreePath path) {
        if (path != null) {
            try {
                DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)path.getLastPathComponent();
                return (NodeWrapper)tmp.getUserObject();
            }
            catch (ClassCastException cce) {
                return null;
            }
        }
        return null;
    }

    public void addFilter(CoverageTreeFilter aFilter) {
        this.addFilterFirst(aFilter);
    }

    public void addFilterFirst(CoverageTreeFilter aFilter) {
        this.filters.addFirst(aFilter);
        this.mTree = null;
    }

    public void addFilterLast(CoverageTreeFilter aFilter) {
        this.filters.addLast(aFilter);
        this.mTree = null;
    }

    public void removeFilter(CoverageTreeFilter aFilter) {
        this.filters.remove(aFilter);
        this.mTree = null;
    }

    public boolean hasFilter(CoverageTreeFilter aFilter) {
        return this.filters.contains(aFilter);
    }

    private void applyFilters() {
        this.filter(this.mTree);
    }

    private void filter(DefaultMutableTreeNode aNode) {
        if (aNode.getChildCount() > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)aNode.getFirstChild();
            while (child != null) {
                DefaultMutableTreeNode sibling = child.getNextSibling();
                this.filter(child);
                child = sibling;
            }
        }
        for (CoverageTreeFilter filter : this.filters) {
            if (filter.accept(aNode)) continue;
            aNode.removeFromParent();
            return;
        }
    }

    public class NodeWrapper {
        private final String id;
        private final HasMetrics hasMetrics;
        private BaseCoverageNodeViewer.TestPassInfo testPassInfo;

        public NodeWrapper(String id, HasMetrics hasMetrics, BaseCoverageNodeViewer.TestPassInfo testPassInfo) {
            this.id = id;
            this.hasMetrics = hasMetrics;
            this.testPassInfo = testPassInfo;
        }

        public NodeWrapper(String id, HasMetrics hasMetrics) {
            this(id, hasMetrics, null);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.hasMetrics.getName();
        }

        public HasMetrics getHasMetrics() {
            return this.hasMetrics;
        }

        public BaseCoverageNodeViewer.TestPassInfo getTestPassInfo() {
            if (this.testPassInfo == null) {
                this.testPassInfo = this.hasMetrics instanceof PackageFragment ? CoverageTreeModel.this.calculatePFTestPasses((PackageFragment)this.hasMetrics) : CoverageTreeModel.this.calculateTestPasses((CoverageDataReceptor)((Object)this.hasMetrics));
            }
            return this.testPassInfo;
        }

        public String toString() {
            BlockMetrics metrics = this.hasMetrics.getMetrics();
            StringBuilder sb = new StringBuilder(this.getName());
            sb.append(" (");
            sb.append(Formatting.getPercentStr(this.hasMetrics.getMetrics().getPcCoveredElements()));
            if (metrics instanceof FileMetrics) {
                sb.append(" / ");
                sb.append(((FileMetrics)metrics).getNcLineCount());
                sb.append(" lines");
            }
            sb.append(" / ");
            if (metrics instanceof ClassMetrics) {
                sb.append(Formatting.format2d(((ClassMetrics)metrics).getAvgMethodComplexity()));
            } else {
                sb.append(metrics.getComplexity());
            }
            sb.append(" )");
            return sb.toString();
        }
    }
}

