/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.content;

import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.registry.CoverageDataReceptor;
import com.atlassian.clover.registry.FileElementVisitor;
import com.intellij.openapi.editor.LogicalPosition;
import java.util.Collection;
import org.openclover.util.Lists;

public class StatementsAggregatingVisitor
implements FileElementVisitor {
    private final Collection<ClassInfo> classInfos = Lists.newLinkedList();
    private final Collection<MethodInfo> methodInfos = Lists.newLinkedList();
    private final Collection<StatementInfo> statementInfos = Lists.newLinkedList();
    private final Collection<BranchInfo> branchInfos = Lists.newLinkedList();
    private final LogicalPosition position;
    private final MostNarrowHelper mostNarrowStatementHelper = new MostNarrowHelper();
    private final MostNarrowHelper mostNarrowMethodHelper = new MostNarrowHelper();
    private final MostNarrowHelper mostNarrowClassHelper = new MostNarrowHelper();

    public Collection<BranchInfo> getBranchInfos() {
        return this.branchInfos;
    }

    public Collection<ClassInfo> getClassInfos() {
        return this.classInfos;
    }

    public Collection<MethodInfo> getMethodInfos() {
        return this.methodInfos;
    }

    public Collection<StatementInfo> getStatementInfos() {
        return this.statementInfos;
    }

    public StatementsAggregatingVisitor(LogicalPosition position) {
        this.position = new LogicalPosition(position.line + 1, position.column);
    }

    public CoverageDataReceptor getMostNarrowClass() {
        return (CoverageDataReceptor)((Object)this.mostNarrowClassHelper.getMostNarrowOne());
    }

    public CoverageDataReceptor getMostNarrowMethod() {
        return (CoverageDataReceptor)((Object)this.mostNarrowMethodHelper.getMostNarrowOne());
    }

    public CoverageDataReceptor getMostNarrowStatement() {
        return (CoverageDataReceptor)((Object)this.mostNarrowStatementHelper.getMostNarrowOne());
    }

    private boolean contains(SourceInfo element) {
        LogicalPosition start = new LogicalPosition(element.getStartLine(), element.getStartColumn() - 1);
        LogicalPosition end = new LogicalPosition(element.getEndLine(), element.getEndColumn() - 1);
        return this.position.compareTo(start) >= 0 && this.position.compareTo(end) < 0;
    }

    @Override
    public void visitClass(ClassInfo info) {
        if (this.contains(info)) {
            this.mostNarrowClassHelper.updateMostNarrowRegion(info);
            this.classInfos.add(info);
        }
    }

    @Override
    public void visitMethod(MethodInfo info) {
        if (this.contains(info)) {
            this.mostNarrowMethodHelper.updateMostNarrowRegion(info);
            this.methodInfos.add(info);
        }
    }

    @Override
    public void visitStatement(StatementInfo info) {
        if (this.contains(info)) {
            this.mostNarrowStatementHelper.updateMostNarrowRegion(info);
            this.statementInfos.add(info);
        }
    }

    @Override
    public void visitBranch(BranchInfo info) {
        if (this.contains(info)) {
            this.mostNarrowStatementHelper.updateMostNarrowRegion(info);
            this.branchInfos.add(info);
        }
    }

    static class MostNarrowHelper {
        private SourceInfo mostNarrowOne;
        private LogicalPosition mostNarrowStart;
        private LogicalPosition mostNarrowEnd;

        MostNarrowHelper() {
        }

        SourceInfo getMostNarrowOne() {
            return this.mostNarrowOne;
        }

        private void updateMostNarrowRegion(SourceInfo candidate) {
            if (this.mostNarrowOne == null) {
                this.mostNarrowOne = candidate;
                this.mostNarrowStart = new LogicalPosition(candidate.getStartLine(), candidate.getStartColumn());
                this.mostNarrowEnd = new LogicalPosition(candidate.getEndLine(), candidate.getEndColumn());
            } else {
                LogicalPosition start = new LogicalPosition(candidate.getStartLine(), candidate.getStartColumn());
                LogicalPosition end = new LogicalPosition(candidate.getEndLine(), candidate.getEndColumn());
                if (start.compareTo(this.mostNarrowStart) >= 0 && end.compareTo(this.mostNarrowEnd) <= 0) {
                    this.mostNarrowOne = candidate;
                    this.mostNarrowStart = start;
                    this.mostNarrowEnd = end;
                }
            }
        }
    }
}

