/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.content;

import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.content.DocMarkupPlugin;
import com.atlassian.clover.idea.content.ToolTipPlugin;
import com.atlassian.clover.idea.coverage.EventListenerInstallator;
import com.atlassian.clover.idea.feature.FeatureEvent;
import com.atlassian.clover.idea.feature.FeatureListener;
import com.atlassian.clover.idea.feature.FeatureManager;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class ContentManager
implements FileEditorManagerListener,
ConfigChangeListener {
    private final Project project;
    private final Map<VirtualFile, MultiPluginHandler> activePlugins = Maps.newHashMap();

    public ContentManager(Project project) {
        this.project = project;
        ProjectPlugin.getPlugin(project).getConfig().addConfigChangeListener(this);
    }

    public void init() {
        FeatureManager fManager = ProjectPlugin.getPlugin(this.project).getFeatureManager();
        fManager.addFeatureListener("clover", new FeatureListener(){

            @Override
            public void featureStateChanged(FeatureEvent evt) {
                if (evt.isEnabled()) {
                    ContentManager.this.install();
                } else {
                    ContentManager.this.uninstall();
                }
            }
        });
        if (fManager.isFeatureEnabled("clover")) {
            this.install();
        }
    }

    public void cleanup() {
        this.uninstall();
    }

    private void install() {
        FileEditorManager fManager = FileEditorManager.getInstance((Project)this.project);
        for (VirtualFile openFile : fManager.getOpenFiles()) {
            this.attachPluginTo(fManager, openFile);
        }
        EventListenerInstallator.install(this.project, FileEditorManagerListener.FILE_EDITOR_MANAGER, this);
    }

    private void uninstall() {
        LinkedList<VirtualFile> openFiles = Lists.newLinkedList(this.activePlugins.keySet());
        for (VirtualFile openFile : openFiles) {
            this.dettachPluginFrom(openFile);
        }
    }

    private void attachPluginTo(FileEditorManager fManager, VirtualFile openFile) {
        FileType type;
        if (this.activePlugins.containsKey(openFile)) {
            this.dettachPluginFrom(openFile);
        }
        if (!VfsUtil.isFileInJar(openFile) && (type = FileTypeManager.getInstance().getFileTypeByFile(openFile)) instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().equals(JavaLanguage.INSTANCE)) {
            FileEditor[] editors;
            Editor editor = null;
            for (FileEditor fileEditor : editors = fManager.getEditors(openFile)) {
                if (!(fileEditor instanceof TextEditor)) continue;
                editor = ((TextEditor)fileEditor).getEditor();
                break;
            }
            if (editor != null) {
                MultiPluginHandler plugin = new MultiPluginHandler(this.project, openFile);
                plugin.install(editor);
                this.activePlugins.put(openFile, plugin);
            }
        }
    }

    private void dettachPluginFrom(VirtualFile openFile) {
        MultiPluginHandler plugin = this.activePlugins.remove(openFile);
        if (plugin != null) {
            plugin.uninstall();
        }
    }

    public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile openedFile) {
        this.attachPluginTo(manager, openedFile);
    }

    public void fileClosed(@NotNull FileEditorManager manager, @NotNull VirtualFile file) {
        this.dettachPluginFrom(file);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent manager) {
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        if (evt.hasPropertyChange("blah")) {
            for (MultiPluginHandler plugin : this.activePlugins.values()) {
                plugin.refresh();
            }
        }
    }

    static class MultiPluginHandler {
        private final DocMarkupPlugin markupPlugin;
        private final ToolTipPlugin toolTipPlugin;

        public MultiPluginHandler(Project proj, VirtualFile vf) {
            this.markupPlugin = new DocMarkupPlugin(proj, vf);
            this.toolTipPlugin = new ToolTipPlugin(proj, vf);
        }

        public void install(Editor editor) {
            this.markupPlugin.install(editor);
            this.toolTipPlugin.install(editor);
        }

        public void uninstall() {
            this.markupPlugin.uninstall();
            this.toolTipPlugin.uninstall();
        }

        public void refresh() {
            this.markupPlugin.refresh();
            this.toolTipPlugin.refresh();
        }
    }
}

