/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config.regexp;

import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.idea.config.regexp.Regexp;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexpValidator {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[^\\s,]+$");
    public static final RegexpValidator CONTEXTLESS_VALIDATOR = new RegexpValidator();

    public void validate(Regexp regexp) {
        String pattern = regexp.getRegex();
        if (pattern != null && pattern.length() > 0) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                regexp.setValidationMessage("Pattern '" + pattern + "' is invalid.");
                return;
            }
        } else {
            regexp.setValidationMessage("Pattern is empty.");
            return;
        }
        String name = regexp.getName();
        if (name == null || name.length() == 0) {
            regexp.setValidationMessage("Context name must not be empty.");
            return;
        }
        if (!NAME_PATTERN.matcher(name).matches()) {
            regexp.setValidationMessage("Context name must not contain whitespaces or ',' character.");
            return;
        }
        if (ContextStore.isReservedName(name)) {
            regexp.setValidationMessage("Context name is reserved.");
            return;
        }
        regexp.setValidationMessage(null);
    }
}

