/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config.regexp;

import com.atlassian.clover.idea.config.ContextFilterRegexpType;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.idea.config.regexp.RegexpConfigModel;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.ui.LayeredIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RegexpListPanel
extends JPanel
implements Observer,
ListSelectionListener {
    private RegexpConfigModel model;
    private JList filterList;
    private boolean isUpdating;

    public RegexpListPanel() {
        this.initLayout();
        this.initListeners();
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this.getFilterList()), new GBC(0, 0).setFill(1).setWeight(0.01, 0.01));
    }

    private void initListeners() {
        this.getFilterList().addListSelectionListener(this);
        this.getFilterList().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!RegexpListPanel.this.isEnabled()) {
                    return;
                }
                Point location = e.getPoint();
                if (!IdeaRegexpCellRenderer.getInstance().inCbRange(location.x)) {
                    return;
                }
                int index = RegexpListPanel.this.getFilterList().locationToIndex(location);
                if (index != -1) {
                    Regexp regexp;
                    regexp.setEnabled(!(regexp = (Regexp)RegexpListPanel.this.getFilterList().getModel().getElementAt(index)).isEnabled());
                    regexp.notifyObservers();
                    RegexpListPanel.this.repaint();
                }
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!this.isUpdating) {
            this.model.setSelected((Regexp)this.getFilterList().getSelectedValue());
            this.model.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(RegexpConfigModel configModel) {
        if (this.model != null) {
            this.model.deleteObserver(this);
        }
        RegexpListPanel regexpListPanel = this;
        synchronized (regexpListPanel) {
            try {
                this.isUpdating = true;
                this.model = configModel;
                this.syncModels();
            }
            finally {
                this.isUpdating = false;
            }
        }
        if (this.model != null) {
            this.model.addObserver(this);
        }
    }

    private void syncModels() {
        DefaultListModel listModel = (DefaultListModel)this.getFilterList().getModel();
        listModel.clear();
        if (this.model == null) {
            return;
        }
        Iterator<Regexp> regexps = this.model.getRegexps().iterator();
        if (regexps.hasNext()) {
            while (regexps.hasNext()) {
                Regexp next = regexps.next();
                listModel.addElement(next);
            }
            if (this.model.getSelected() != null) {
                this.getFilterList().setSelectedValue(this.model.getSelected(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        RegexpListPanel regexpListPanel = this;
        synchronized (regexpListPanel) {
            try {
                this.isUpdating = true;
                if (arg == "edit") {
                    this.getFilterList().repaint();
                } else {
                    this.syncModels();
                }
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    private JList getFilterList() {
        if (this.filterList == null) {
            this.filterList = new JList();
            this.filterList.setModel(new DefaultListModel());
            this.filterList.setSelectionMode(0);
            this.filterList.setVisibleRowCount(7);
            this.filterList.setCellRenderer(IdeaRegexpCellRenderer.getInstance());
        }
        return this.filterList;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.getFilterList().setEnabled(b);
    }

    static class IdeaRegexpCellRenderer
    implements ListCellRenderer {
        private static final LayeredIcon INVALID_METHOD_ICON = new LayeredIcon(2);
        private static final LayeredIcon INVALID_STATEMENT_ICON = new LayeredIcon(2);
        private static final JCheckBox CHECKBOX;
        private static final JLabel LABEL;
        private static final JPanel COMPONENT;
        private static final Border NO_FOCUS_BORDER;
        private static final Color DISABLED_BG;
        private static final IdeaRegexpCellRenderer INSTANCE;

        IdeaRegexpCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color bg = isSelected ? (list.isEnabled() ? list.getSelectionBackground() : DISABLED_BG) : list.getBackground();
            Color fg = isSelected ? list.getSelectionForeground() : list.getForeground();
            COMPONENT.setBackground(bg);
            COMPONENT.setForeground(fg);
            CHECKBOX.setBackground(bg);
            CHECKBOX.setForeground(fg);
            LABEL.setBackground(bg);
            LABEL.setForeground(fg);
            CHECKBOX.setEnabled(list.isEnabled());
            COMPONENT.setEnabled(list.isEnabled());
            COMPONENT.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : NO_FOCUS_BORDER);
            if (value instanceof Regexp) {
                Regexp ctx = (Regexp)value;
                if (ctx.getType() == ContextFilterRegexpType.Method.ordinal()) {
                    if (ctx.isValid()) {
                        LABEL.setIcon(CloverIcons.METHOD_ICON);
                    } else {
                        LABEL.setIcon((Icon)INVALID_METHOD_ICON);
                    }
                } else if (ctx.getType() == ContextFilterRegexpType.Statement.ordinal()) {
                    if (ctx.isValid()) {
                        LABEL.setIcon(CloverIcons.STATEMENT_ICON);
                    } else {
                        LABEL.setIcon((Icon)INVALID_STATEMENT_ICON);
                    }
                } else {
                    LABEL.setIcon(null);
                }
                LABEL.setText(ctx.getName());
                CHECKBOX.setSelected(ctx.isEnabled());
                if (ctx.isChanged()) {
                    LABEL.setForeground(Color.BLUE);
                }
            }
            return COMPONENT;
        }

        boolean inCbRange(int x) {
            Rectangle r = CHECKBOX.getBounds();
            return r.getMinX() <= (double)x && r.getMaxX() >= (double)x;
        }

        private static IdeaRegexpCellRenderer getInstance() {
            return INSTANCE;
        }

        static {
            INVALID_METHOD_ICON.setIcon(CloverIcons.METHOD_ICON, 0);
            INVALID_METHOD_ICON.setIcon(CloverIcons.CONFIGURATION_INVALID, 1);
            INVALID_STATEMENT_ICON.setIcon(CloverIcons.STATEMENT_ICON, 0);
            INVALID_STATEMENT_ICON.setIcon(CloverIcons.CONFIGURATION_INVALID, 1);
            CHECKBOX = new JCheckBox();
            LABEL = new JLabel();
            COMPONENT = new JPanel();
            NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
            COMPONENT.setLayout(new GridBagLayout());
            COMPONENT.add((Component)CHECKBOX, new GBC(0, 0));
            COMPONENT.add((Component)LABEL, new GBC(1, 0).setFill(1).setWeight(1.0, 0.0));
            CHECKBOX.setBorder(NO_FOCUS_BORDER);
            DISABLED_BG = UIManager.getColor("inactiveCaption");
            INSTANCE = new IdeaRegexpCellRenderer();
        }
    }
}

