/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config.regexp;

import com.atlassian.clover.idea.config.ContextFilterRegexpType;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.idea.util.ComparatorUtil;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.DocumentAdapter;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditRegexpPanel
extends JPanel
implements Observer {
    private Regexp model;
    private static final String METHOD_HELP = "<html>" + CloverIdeaPluginMessages.METHOD_CONTEXT_FILTER_INSTRUCTIONS_HTML();
    private static final String STATEMENT_HELP = "<html>" + CloverIdeaPluginMessages.STATEMENT_CONTEXT_FILTER_INSTRUCTIONS_HTML();
    private JLabel nameLabel;
    private JLabel typeLabel;
    private JLabel regexpLabel;
    private JTextField nameField;
    private JComboBox typeComboBox;
    private JTextField regexpField;
    private boolean isUpdating;
    private String helpTitle;
    private String helpText;

    public EditRegexpPanel() {
        this.initLayout();
        this.initListeners();
    }

    public void setModel(Regexp configModel) {
        if (!this.isUpdating) {
            try {
                this.isUpdating = true;
                if (this.model != null) {
                    this.model.deleteObserver(this);
                }
                if (configModel != null) {
                    this.getNameField().setText(configModel.getName());
                    this.getRegexpField().setText(configModel.getRegex());
                    this.getTypeComboBox().setSelectedItem(this.getTypeNameFromId(configModel.getType()));
                } else {
                    this.getNameField().setText("");
                    this.getRegexpField().setText("");
                    this.getTypeComboBox().setSelectedItem(ContextFilterRegexpType.Method.name());
                }
                this.model = configModel;
                if (this.model != null) {
                    this.model.addObserver(this);
                }
                this.setEnabled(this.model != null);
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getNameLabel(), new GBC(1, 1).setAnchor(13).setInsets(6, 6, 5, 5));
        this.add((Component)this.getNameField(), new GBC(2, 1).setInsets(6, 0, 5, 6).setFill(2).setWeight(1.0, 0.0));
        this.add((Component)this.getTypeLabel(), new GBC(1, 2).setAnchor(13).setInsets(0, 6, 5, 5));
        this.add((Component)this.getTypeComboBox(), new GBC(2, 2).setInsets(0, 0, 5, 6).setFill(2));
        this.add((Component)this.getRegexpLabel(), new GBC(1, 3).setAnchor(13).setInsets(0, 6, 5, 5));
        this.add((Component)this.getRegexpField(), new GBC(2, 3).setInsets(0, 0, 5, 6).setFill(2));
        this.add((Component)new JPanel(), new GBC(1, 5).setFill(1).setWeight(0.0, 1.0));
    }

    private void initListeners() {
        DocumentAdapter l = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                EditRegexpPanel.this.handleEditUiUpdate();
            }
        };
        this.getNameField().getDocument().addDocumentListener((DocumentListener)l);
        this.getRegexpField().getDocument().addDocumentListener((DocumentListener)l);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditRegexpPanel.this.handleEditUiUpdate();
            }
        };
        this.getTypeComboBox().addActionListener(al);
    }

    private void handleEditUiUpdate() {
        if (!this.isUpdating) {
            try {
                this.isUpdating = true;
                if (this.model == null) {
                    return;
                }
                if (!ComparatorUtil.areEqual(this.model.getName(), this.getNameField().getText())) {
                    this.model.setName(this.getNameField().getText());
                }
                if (!ComparatorUtil.areEqual(this.model.getRegex(), this.getRegexpField().getText())) {
                    this.model.setRegex(this.getRegexpField().getText());
                }
                if (this.model.getType() != this.getTypeIdFromString(this.getTypeComboBox().getSelectedItem().toString())) {
                    this.model.setType(this.getTypeIdFromString(this.getTypeComboBox().getSelectedItem().toString()));
                }
                this.model.notifyObservers();
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    private JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel("Name:");
            this.nameLabel.setAlignmentX(1.0f);
        }
        return this.nameLabel;
    }

    private JLabel getTypeLabel() {
        if (this.typeLabel == null) {
            this.typeLabel = new JLabel("Type:");
            this.typeLabel.setAlignmentX(1.0f);
        }
        return this.typeLabel;
    }

    private JLabel getRegexpLabel() {
        if (this.regexpLabel == null) {
            this.regexpLabel = new JLabel("Regexp:", CloverIcons.HELP, 4);
            this.regexpLabel.setDisabledIcon(CloverIcons.HELP);
            this.regexpLabel.setHorizontalTextPosition(2);
            this.regexpLabel.setAlignmentX(1.0f);
            this.regexpLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Messages.showInfoMessage((String)EditRegexpPanel.this.helpText, (String)EditRegexpPanel.this.helpTitle);
                }
            });
        }
        return this.regexpLabel;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
        }
        return this.nameField;
    }

    private JTextField getRegexpField() {
        if (this.regexpField == null) {
            this.regexpField = new JTextField();
        }
        return this.regexpField;
    }

    private void setRegexpHelp(ContextFilterRegexpType selected) {
        this.helpText = selected == ContextFilterRegexpType.Method ? METHOD_HELP : STATEMENT_HELP;
        this.helpTitle = "Help for " + (Object)((Object)selected) + " Regexp";
        this.getRegexpLabel().setToolTipText(this.helpText);
        this.getRegexpField().setToolTipText(this.helpText);
    }

    private JComboBox getTypeComboBox() {
        if (this.typeComboBox == null) {
            this.typeComboBox = new JComboBox();
            this.typeComboBox.addItem(ContextFilterRegexpType.Method.name());
            this.typeComboBox.addItem(ContextFilterRegexpType.Statement.name());
            this.setRegexpHelp(ContextFilterRegexpType.Method);
            this.typeComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        EditRegexpPanel.this.setRegexpHelp(ContextFilterRegexpType.valueOf(e.getItem().toString()));
                    }
                }
            });
        }
        return this.typeComboBox;
    }

    private int getTypeIdFromString(String str) {
        if (str.equals(ContextFilterRegexpType.Method.name())) {
            return ContextFilterRegexpType.Method.ordinal();
        }
        if (str.equals(ContextFilterRegexpType.Statement.name())) {
            return ContextFilterRegexpType.Statement.ordinal();
        }
        return -1;
    }

    private String getTypeNameFromId(int type) {
        if (type == ContextFilterRegexpType.Method.ordinal()) {
            return ContextFilterRegexpType.Method.name();
        }
        if (type == ContextFilterRegexpType.Statement.ordinal()) {
            return ContextFilterRegexpType.Statement.name();
        }
        return "Unknown";
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean doEnable = enabled && this.model != null;
        super.setEnabled(doEnable);
        this.getNameLabel().setEnabled(doEnable);
        this.getNameField().setEnabled(doEnable);
        this.getTypeLabel().setEnabled(doEnable);
        this.getTypeComboBox().setEnabled(doEnable);
        this.getRegexpLabel().setEnabled(doEnable);
        this.getRegexpField().setEnabled(doEnable);
    }
}

