/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.util.ui.UIUtils;
import com.atlassian.clover.util.ArrayUtil;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class InstrumentationConfigPanel
extends ConfigPanel
implements ActionListener {
    private JTextArea helpText;
    private JTextField includeField;
    private JLabel includeLabel;
    private JTextField excludeField;
    private JLabel excludeLabel;
    private JCheckBox ignoreTests;
    private JLabel instrumentLambdaLabel;
    private ComboBox instrumentLambdaCombo;

    public InstrumentationConfigPanel() {
        this.initLayout();
        this.initListeners();
    }

    private void initLayout() {
        this.setBorder(this.getEnabledBorder());
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        int row = 0;
        this.add((Component)this.getHelpText(), new GBC(1, ++row).setInsets(0, 6, 5, 6).setSpan(2, 1).setFill(2).setWeight(1.0, 0.0));
        this.add((Component)this.getIncludeLabel(), new GBC(1, ++row).setInsets(0, 6, 5, 5).setAnchor(17).setWeight(0.0, 0.0));
        this.add((Component)this.getInclude(), new GBC(2, row).setInsets(0, 0, 5, 6).setFill(2).setWeight(1.0, 0.0));
        this.add((Component)this.getExcludeLabel(), new GBC(1, ++row).setInsets(0, 6, 5, 5).setAnchor(17).setWeight(0.0, 0.0));
        this.add((Component)this.getExclude(), new GBC(2, row).setInsets(0, 0, 5, 6).setFill(2).setWeight(1.0, 0.0));
        this.add((Component)this.getInstrumentTests(), new GBC(1, ++row).setInsets(0, 6, 10, 6).setSpan(2, 1).setAnchor(17).setFill(1).setWeight(1.0, 0.0));
        this.add((Component)this.getInstrumentLambdaLabel(), new GBC(1, ++row).setInsets(0, 6, 5, 5).setAnchor(17).setWeight(0.0, 0.0));
        this.add((Component)this.getInstrumentLambdaCombo(), new GBC(2, row).setInsets(0, 0, 5, 6).setFill(2).setWeight(1.0, 0.0));
        this.add((Component)new JPanel(), new GBC(1, ++row).setSpan(2, 1).setFill(1).setWeight(0.0, 1.0));
    }

    private void initListeners() {
    }

    private static String processText(String str) {
        if (str == null) {
            return null;
        }
        String trimmed = str.trim();
        return trimmed.length() == 0 ? null : trimmed;
    }

    @Override
    public void commitTo(CloverPluginConfig config) {
        IdeaCloverConfig ideaConfig = (IdeaCloverConfig)config;
        ideaConfig.setIncludes(InstrumentationConfigPanel.processText(this.getInclude().getText()));
        ideaConfig.setExcludes(InstrumentationConfigPanel.processText(this.getExclude().getText()));
        ideaConfig.setInstrumentTests(this.getInstrumentTests().isSelected());
        ideaConfig.setInstrumentLambda(LambdaInstrumentation.values()[this.getInstrumentLambdaCombo().getSelectedIndex()]);
    }

    @Override
    public void loadFrom(CloverPluginConfig config) {
        IdeaCloverConfig ideaConfig = (IdeaCloverConfig)config;
        this.getInclude().setText(ideaConfig.getIncludes());
        this.getExclude().setText(ideaConfig.getExcludes());
        this.getInstrumentTests().setSelected(ideaConfig.isInstrumentTests());
        this.getInstrumentLambdaCombo().setSelectedIndex(ideaConfig.getInstrumentLambda().ordinal());
    }

    private JTextArea getHelpText() {
        if (this.helpText == null) {
            this.helpText = UIUtils.getHelpTextArea("Fine tune which source files you want instrumented by Clover. Specify Ant style patternsets to include or exclude particular source files (comma or space separated).", this.getBackground(), this.getFont());
        }
        return this.helpText;
    }

    private JTextField getInclude() {
        if (this.includeField == null) {
            this.includeField = new JTextField();
        }
        return this.includeField;
    }

    private JLabel getIncludeLabel() {
        if (this.includeLabel == null) {
            this.includeLabel = new JLabel("Includes:");
            this.includeLabel.setAlignmentX(1.0f);
        }
        return this.includeLabel;
    }

    private JTextField getExclude() {
        if (this.excludeField == null) {
            this.excludeField = new JTextField();
        }
        return this.excludeField;
    }

    private JLabel getExcludeLabel() {
        if (this.excludeLabel == null) {
            this.excludeLabel = new JLabel("Excludes:");
            this.excludeLabel.setAlignmentX(1.0f);
        }
        return this.excludeLabel;
    }

    private JCheckBox getInstrumentTests() {
        if (this.ignoreTests == null) {
            this.ignoreTests = new JCheckBox("<html>Instrument test source folders to enable per-test coverage and test optimization.");
        }
        return this.ignoreTests;
    }

    public JLabel getInstrumentLambdaLabel() {
        if (this.instrumentLambdaLabel == null) {
            this.instrumentLambdaLabel = new JLabel("Instrument lambda functions:");
            this.instrumentLambdaLabel.setAlignmentX(1.0f);
        }
        return this.instrumentLambdaLabel;
    }

    public ComboBox getInstrumentLambdaCombo() {
        if (this.instrumentLambdaCombo == null) {
            this.instrumentLambdaCombo = new ComboBox((Object[])ArrayUtil.toLowerCaseStringArray((Object[])LambdaInstrumentation.values()), 100);
            this.instrumentLambdaCombo.setToolTipText("<html><body>Select whether lambda functions introduced in Java8 shall be instrumented by Clover so that you can track <br/>code coverage for them and show them in reports similarly as normal methods. <br/>You can also limit instrumentation to certain forms of lambda functions: <br/> <li> written as expressions, e.g. '(a + b) -> a + b' </li> <li> written as code blocks, e.g. '() -> { return xyz(); }'</li> <li> written in any form except method references, e.g. 'Math::abs'</li></body></html>");
        }
        return this.instrumentLambdaCombo;
    }

    @Override
    public String getTitle() {
        return "Instrumentation";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void enableConfig(boolean b) {
        super.enableConfig(b);
        this.getInstrumentTests().setForeground(b ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
    }
}

