/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.config.GBC;
import com.atlassian.clover.idea.config.regexp.EditRegexpPanel;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.idea.config.regexp.RegexpConfigModel;
import com.atlassian.clover.idea.config.regexp.RegexpListPanel;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.idea.util.ui.MessageDialogs;
import com.atlassian.clover.idea.util.ui.RichLabel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.EtchedBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.openclover.util.Lists;

public class IdeaRegexpConfigPanel
extends ConfigPanel
implements Observer {
    private static final Key<IdeaRegexpConfigPanel> COMPONENT_KEY = Key.create((String)IdeaRegexpConfigPanel.class.getName());
    private final RegexpConfigModel model;
    private RegexpListPanel listPanel;
    private EditRegexpPanel editPanel;
    private BlankPanel blankPanel;
    private Project project;
    private final List<Component> components = Lists.newArrayList();
    private ValidationResultPanel globalInfoPane;
    private ValidationResultPanel validationPane;

    public IdeaRegexpConfigPanel(Project project, ContextStore registry) {
        this.model = new RegexpConfigModel(registry);
        this.initLayout();
        this.initListeners();
        this.project = project;
        project.putUserData(COMPONENT_KEY, (Object)this);
    }

    public static IdeaRegexpConfigPanel getInstance(Project project) {
        return (IdeaRegexpConfigPanel)project.getUserData(COMPONENT_KEY);
    }

    public void cleanup() {
        this.project.putUserData(COMPONENT_KEY, null);
    }

    public RegexpConfigModel getModel() {
        return this.model;
    }

    public void doAdd() {
        Regexp newCtx = new Regexp(this.model.getModelContextRegexpValidator());
        newCtx.setName(Regexp.suggestNewName(this.model.getRegexps()));
        newCtx.setRegex("");
        newCtx.setChanged(true);
        newCtx.setEnabled(true);
        this.model.add(newCtx);
        this.model.setSelected(newCtx);
        this.model.notifyObservers();
    }

    public void doCopy() {
        Regexp orig = this.model.getSelected();
        Regexp copy = new Regexp(orig);
        copy.setName(Regexp.suggestCopyName(orig, this.model.getRegexps()));
        copy.setChanged(true);
        this.model.add(copy);
        this.model.setSelected(copy);
        this.model.notifyObservers();
    }

    public void doRemove() {
        int response = MessageDialogs.showYesNoDialog(this, "Are you sure you want to delete the selected filter?", "Confirm Filter Delete");
        if (response != 0) {
            return;
        }
        Regexp selectedValue = this.model.getSelected();
        this.model.remove(selectedValue);
        this.model.notifyObservers();
    }

    @Override
    public void commitTo(CloverPluginConfig data) {
        this.model.commitTo(data);
    }

    @Override
    public void loadFrom(CloverPluginConfig data) {
        this.model.loadFrom(data);
        Iterator<Regexp> i = this.model.getRegexps().iterator();
        if (i.hasNext()) {
            this.model.setSelected(i.next());
        }
        Regexp selected = this.model.getSelected();
        this.getEditPanel().setModel(selected);
        if (selected != null) {
            this.getValidationPane().setData(selected.getValidationMessage());
        }
        this.model.notifyObservers();
    }

    @Override
    public String getTitle() {
        return "Custom Contexts";
    }

    @Override
    public void enableConfig(boolean b) {
        super.enableConfig(b);
        for (Component component : this.components) {
            component.setEnabled(b);
        }
        this.setEnabled(b);
    }

    @Override
    public void update(Observable o, Object arg) {
        Regexp selected = this.model.getSelected();
        if (arg == null || arg.equals("selected")) {
            this.getEditPanel().setModel(selected);
        }
        this.getValidationPane().setData(selected != null ? selected.getValidationMessage() : "");
        boolean hasChanged = false;
        for (Regexp regexp : this.model.getRegexps()) {
            if (!regexp.isChanged()) continue;
            hasChanged = true;
            break;
        }
        if (hasChanged) {
            this.getGlobalInfoPane().setData("You made changes to some context filters. Changes will only take effect after a full rebuild of your project.");
        } else {
            this.getGlobalInfoPane().setData(null);
        }
    }

    private void initLayout() {
        this.setBorder(this.getEnabledBorder());
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        RichLabel instructions = new RichLabel("<html>" + CloverIdeaPluginMessages.REGEXP_CONTEXT_FILTER_INSTRUCTIONS());
        this.add((Component)instructions, new GBC(1, 0).setWeight(1.0, 0.0).setFill(2).setInsets(5));
        Splitter splitter = new Splitter(false, 0.4f);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setShowDividerControls(true);
        splitter.setFirstComponent((JComponent)this.createSelectPane());
        splitter.setSecondComponent((JComponent)this.createEditPane());
        this.add((Component)splitter, new GBC(1, 1).setFill(1).setWeight(1.0, 1.0).setAnchor(18));
        this.add((Component)this.getGlobalInfoPane(), new GBC(1, 2).setFill(2).setWeight(1.0, 0.0).setInsets(3));
    }

    private void initListeners() {
        this.getListPanel().setModel(this.model);
        this.model.addObserver(this);
    }

    private JPanel createSelectPane() {
        JPanel selectPane = new JPanel();
        selectPane.setLayout(new GridBagLayout());
        selectPane.add((Component)this.createToolbar(), new GBC(1, 1).setAnchor(18).setWeight(1.0, 0.0).setFill(1));
        selectPane.add((Component)this.getListPanel(), new GBC(1, 2).setAnchor(18).setFill(1).setWeight(1.0, 1.0));
        this.components.addAll(Arrays.asList(selectPane.getComponents()));
        return selectPane;
    }

    private JPanel createEditPane() {
        JPanel editPane = new JPanel();
        editPane.setLayout(new GridBagLayout());
        editPane.add((Component)this.getBlankPanel(), new GBC(1, 1).setAnchor(13).setFill(1).setWeight(1.0, 1.0));
        editPane.add((Component)this.getEditPanel(), new GBC(1, 2).setAnchor(13).setFill(1).setWeight(1.0, 1.0));
        editPane.add((Component)this.getValidationPane(), new GBC(1, 3).setAnchor(17).setFill(2).setWeight(0.0, 0.0).setInsets(3));
        this.components.addAll(Arrays.asList(editPane.getComponents()));
        return editPane;
    }

    private BlankPanel getBlankPanel() {
        if (this.blankPanel == null) {
            this.blankPanel = new BlankPanel();
        }
        return this.blankPanel;
    }

    private RegexpListPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new RegexpListPanel();
        }
        return this.listPanel;
    }

    private EditRegexpPanel getEditPanel() {
        if (this.editPanel == null) {
            this.editPanel = new EditRegexpPanel();
        }
        return this.editPanel;
    }

    private ValidationResultPanel getGlobalInfoPane() {
        if (this.globalInfoPane == null) {
            this.globalInfoPane = new ValidationResultPanel(false);
            this.globalInfoPane.setVisible(false);
        }
        return this.globalInfoPane;
    }

    private ValidationResultPanel getValidationPane() {
        if (this.validationPane == null) {
            this.validationPane = new ValidationResultPanel(true);
            this.validationPane.setVisible(false);
        }
        return this.validationPane;
    }

    private JComponent createToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup actionGroup = (ActionGroup)actionManager.getAction("CloverPlugin.ConfigToolBar");
        return actionManager.createActionToolbar("CloverConfig", actionGroup, true).getComponent();
    }

    static class ValidationResultPanel
    extends JPanel {
        private JLabel label;
        private final boolean isError;

        private ValidationResultPanel(boolean isError) {
            this.isError = isError;
            this.initLayout();
        }

        private void initLayout() {
            this.setBorder(new EtchedBorder(){

                @Override
                public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                    g.translate(x, y);
                    g.setColor(this.etchType == 1 ? this.getShadowColor(c) : this.getHighlightColor(c));
                    g.drawLine(0, 0, width - 2, 0);
                    g.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
                    g.drawLine(1, 1, width - 3, 1);
                    g.translate(-x, -y);
                }
            });
            this.setLayout(new GridBagLayout());
            this.add((Component)this.getMessageLabel(), new GBC(1, 1).setFill(2).setAnchor(17).setWeight(0.001, 0.0));
        }

        private JLabel getMessageLabel() {
            if (this.label == null) {
                this.label = new RichLabel();
                this.label.setIcon(this.isError ? CloverIcons.CONFIGURATION_ERROR : CloverIcons.CONFIGURATION_INFO);
                this.label.setAlignmentX(0.0f);
            }
            return this.label;
        }

        public void setData(String msg) {
            if (msg != null && msg.length() > 0) {
                this.getMessageLabel().setText((this.isError ? "<html>Error: " : "<html>") + msg);
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.label.setEnabled(enabled);
            super.setEnabled(enabled);
        }
    }

    static class BlankPanel
    extends JPanel {
        private JTextPane pane;

        public BlankPanel() {
            this.initLayout();
        }

        private void initLayout() {
            this.setLayout(new GridBagLayout());
            DefaultStyledDocument doc = new DefaultStyledDocument();
            Style s = doc.addStyle(null, null);
            StyleConstants.setIcon(s, CloverIcons.GENERAL_ADD);
            Style d = doc.addStyle(null, null);
            StyleConstants.setFontFamily(d, this.getFont().getFamily());
            StyleConstants.setFontSize(d, this.getFont().getSize());
            try {
                doc.insertString(0, "Press the ", d);
                doc.insertString(10, " ", s);
                doc.insertString(11, "button to create a new Regexp Filter configuration.", d);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.pane = new JTextPane();
            this.pane.setBackground(this.getBackground());
            this.pane.setDocument(doc);
            this.pane.setEditable(false);
            this.add((Component)this.pane, new GBC(1, 1).setAnchor(18).setFill(1).setWeight(0.01, 0.0));
            this.add((Component)new JPanel(), new GBC(1, 2).setFill(1).setWeight(0.0, 1.0));
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.pane.setEnabled(enabled);
        }
    }
}

