/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.idea.config.CloverPluginConfig;
import com.atlassian.clover.idea.config.ConfigPanel;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.RichLabel;
import com.atlassian.clover.idea.util.ui.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.openclover.util.Maps;

public class ContextPane
extends ConfigPanel {
    public static final String PANEL_TITLE = "Built-in Contexts";
    private JPanel checkboxPane = new JPanel();
    private Map<String, JCheckBox> checkboxes = Maps.newHashMap();
    private boolean enabled = true;
    private ContextSet filter;
    private ContextStore registry;

    public ContextPane(ContextStore registry, boolean enabled, boolean showDesc) {
        this.enabled = enabled;
        this.registry = registry;
        this.setupCheckboxes(registry);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        this.setLayout(borderLayout);
        if (showDesc) {
            this.setBorder(UIUtils.createBorder(this.getTitle()));
            RichLabel instructions = new RichLabel("<html>" + CloverIdeaPluginMessages.BLOCK_CONTEXT_FILTER_INSTRUCTIONS());
            this.add((Component)instructions, "North");
        }
        this.add((Component)this.checkboxPane, "Center");
    }

    public ContextPane(ContextStore registry) {
        this(registry, true, true);
    }

    private void setContextFilter(ContextStore registry, ContextSet filter) {
        this.filter = filter;
        this.registry = registry;
        for (Map.Entry<String, JCheckBox> cbEntry : this.checkboxes.entrySet()) {
            NamedContext context = registry.getContext(cbEntry.getKey());
            JCheckBox checkbox = cbEntry.getValue();
            checkbox.setSelected(filter.get(context.getIndex()));
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private ContextSet updateFilterState() {
        ContextSet newFilter = new ContextSet(this.filter.size());
        for (Map.Entry<String, JCheckBox> cbEntry : this.checkboxes.entrySet()) {
            boolean enabled = cbEntry.getValue().isSelected();
            int idx = this.registry.getContext(cbEntry.getKey()).getIndex();
            newFilter = newFilter.set(idx, enabled);
        }
        this.filter = newFilter;
        return this.filter;
    }

    private void setupCheckboxes(ContextStore contextRegistry) {
        List<NamedContext> reservedContexts = contextRegistry.getReservedContexts();
        reservedContexts.addAll(contextRegistry.getReservedMethodContexts());
        GridLayout layout = new GridLayout();
        layout.setRows(reservedContexts.size() / 3 + 1);
        this.checkboxPane.setLayout(layout);
        for (NamedContext namedContext : reservedContexts) {
            if (namedContext.getIndex() == 0) continue;
            String contextName = namedContext.getName();
            String displayedName = namedContext.getType() == NamedContext.Type.BLOCK ? CloverIdeaPluginMessages.RESERVED_BLOCK_CONTEXT(contextName) : CloverIdeaPluginMessages.RESERVED_REGEX_CONTEXT(contextName);
            JCheckBox checkBox = new JCheckBox(displayedName, false);
            checkBox.setEnabled(this.enabled);
            this.checkboxes.put(contextName, checkBox);
            this.checkboxPane.add(checkBox);
        }
    }

    public void setContextFilterSpec(String spec) {
        ContextSet filter = this.registry.createContextSetFilter(spec);
        this.setContextFilter(this.registry, filter);
    }

    public String getContextFilterSpec() {
        return this.registry.getContextsAsString(this.updateFilterState());
    }

    @Override
    public void commitTo(CloverPluginConfig data) {
        String spec = this.getContextFilterSpec();
        data.setContextFilterSpec(spec);
    }

    @Override
    public void loadFrom(CloverPluginConfig data) {
        String spec = data.getContextFilterSpec();
        this.setContextFilterSpec(spec);
    }

    @Override
    public String getTitle() {
        return "Built-in context filters";
    }

    @Override
    public void enableConfig(boolean b) {
        super.enableConfig(b);
        this.enabled = b;
        for (JCheckBox checkBox : this.checkboxes.values()) {
            checkBox.setEnabled(this.enabled);
        }
        this.setEnabled(b);
    }
}

