/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.config;

import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.config.ProjectConfigPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;

public class CloverProjectConfigurable
implements Configurable {
    public static final String DISPLAY_NAME = "Clover (project settings)";
    private final IdeaCloverConfig config;
    private final Project project;
    private ProjectConfigPanel configPanel;

    public CloverProjectConfigurable(Project project) {
        this.project = project;
        this.config = ProjectPlugin.getPlugin(project).getConfig();
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        if (this.configPanel == null) {
            this.configPanel = new ProjectConfigPanel(this.project, this.config);
        }
        return this.configPanel;
    }

    public boolean isModified() {
        IdeaCloverConfig tmpConfig = IdeaCloverConfig.fromProject(this.project);
        tmpConfig = this.config.copyConfigTo(tmpConfig);
        tmpConfig.markDirty(false);
        this.configPanel.commitTo(tmpConfig);
        return tmpConfig.isDirty();
    }

    public void apply() throws ConfigurationException {
        this.configPanel.commitTo(this.config);
    }

    public void reset() {
        this.configPanel.loadFrom(this.config);
    }

    public void disposeUIResources() {
        if (this.configPanel != null) {
            this.configPanel = null;
        }
    }
}

