/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build.jps;

import com.atlassian.clover.idea.build.jps.JpsModelUtil;
import com.atlassian.clover.instr.tests.DefaultTestDetector;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.util.trie.FilePathPrefixTree;
import java.io.File;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsProjectTestDetector
implements TestDetector {
    private final TestDetector defaultTestDetector = new DefaultTestDetector();
    private final FilePathPrefixTree<JpsModuleSourceRootType> allSourceRoots;
    private final JpsProject jpsProject;

    public JpsProjectTestDetector(JpsProject jpsProject, FilePathPrefixTree<JpsModuleSourceRootType> allSourceRootsCache) {
        this.jpsProject = jpsProject;
        this.allSourceRoots = allSourceRootsCache;
    }

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        return this.defaultTestDetector.isTypeMatch(sourceContext, typeContext) || this.isInTestFolder(sourceContext.getSourceFile());
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        return this.defaultTestDetector.isMethodMatch(sourceContext, methodContext);
    }

    protected boolean isInTestFolder(File sourceFile) {
        JpsModuleSourceRoot sourceRoot;
        JpsModule module;
        JpsModuleSourceRootType rootType = this.allSourceRoots.findNearest(sourceFile).getValue();
        if (rootType != null && rootType.equals(JavaSourceRootType.TEST_SOURCE) && (module = JpsModelUtil.findModuleForFile(this.jpsProject, sourceFile)) != null && (sourceRoot = JpsModelUtil.findSourceRootForFile(module, sourceFile)) != null) {
            return sourceRoot.getRootType().equals(JavaSourceRootType.TEST_SOURCE);
        }
        return false;
    }
}

