/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build.jps;

import com.atlassian.clover.idea.build.jps.JpsModelUtil;
import com.atlassian.clover.util.trie.FilePathPrefixTree;
import java.io.File;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.LanguageLevel;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JpsProjectPrefixTreeUtil {
    public static FilePathPrefixTree<LanguageLevel> collectLanguageLevels(JpsProject project) {
        FilePathPrefixTree<LanguageLevel> languageLevelTrie = new FilePathPrefixTree<LanguageLevel>(LanguageLevel.JDK_1_7);
        JpsJavaExtensionService javaExt = JpsJavaExtensionService.getInstance();
        for (JpsModule module : project.getModules()) {
            LanguageLevel moduleLevel = javaExt.getLanguageLevel(module);
            for (JpsModuleSourceRoot moduleSourceRoot : module.getSourceRoots()) {
                languageLevelTrie.add(moduleSourceRoot.getFile(), moduleLevel);
            }
        }
        return languageLevelTrie;
    }

    public static FilePathPrefixTree<JpsModule> collectModules(JpsProject project) {
        FilePathPrefixTree<JpsModule> moduleTrie = new FilePathPrefixTree<JpsModule>();
        for (JpsModule module : project.getModules()) {
            for (JpsModuleSourceRoot moduleSourceRoot : module.getSourceRoots()) {
                moduleTrie.add(moduleSourceRoot.getFile(), module);
            }
        }
        return moduleTrie;
    }

    public static FilePathPrefixTree<JpsModuleSourceRootType> collectRootTypes(JpsProject project) {
        FilePathPrefixTree<JpsModuleSourceRootType> moduleTrie = new FilePathPrefixTree<JpsModuleSourceRootType>();
        for (JpsModule module : project.getModules()) {
            for (JpsModuleSourceRoot moduleSourceRoot : module.getSourceRoots()) {
                moduleTrie.add(moduleSourceRoot.getFile(), moduleSourceRoot.getRootType());
            }
        }
        return moduleTrie;
    }

    public static FilePathPrefixTree<Boolean> collectExcludedRoots(JpsProject project) {
        FilePathPrefixTree<Boolean> moduleTrie = new FilePathPrefixTree<Boolean>(Boolean.FALSE);
        for (JpsModule module : project.getModules()) {
            for (File excludedRoot : JpsModelUtil.getExcludedRoots(module)) {
                moduleTrie.add(excludedRoot, Boolean.TRUE);
            }
        }
        return moduleTrie;
    }
}

