/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.build.RebuildProjectDialog;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.config.ProjectRebuild;
import com.atlassian.clover.idea.config.regexp.Regexp;
import com.atlassian.clover.idea.feature.FeatureEvent;
import com.atlassian.clover.idea.feature.FeatureListener;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.beans.PropertyChangeEvent;
import java.util.List;

public class ProjectRebuilder
implements FeatureListener,
ConfigChangeListener {
    private static final Key<ProjectRebuilder> PROJECT_REBUILDER_KEY = Key.create((String)ProjectRebuilder.class.getName());
    private final Project project;
    private static final String[] REBUILD_TRIGGERS = new String[]{"flushInterval", "flushPolicy", "relativeInitString", "automaticInitString", "manualInitString"};

    public ProjectRebuilder(Project project) {
        this.project = project;
    }

    @Override
    public void featureStateChanged(FeatureEvent evt) {
        this.rebuildProject(true);
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        CloverDatabase coverage;
        for (String rebuildTrigger : REBUILD_TRIGGERS) {
            if (!evt.hasPropertyChange(rebuildTrigger)) continue;
            this.rebuildProject();
            return;
        }
        if (evt.hasPropertyChange("regexpContexts") && (coverage = ProjectPlugin.getPlugin(this.project).getCoverageManager().getCoverage()) != null) {
            ContextStore contextStore = coverage.getContextStore();
            PropertyChangeEvent pc = evt.getPropertyChange("regexpContexts");
            List configuredRegexps = (List)pc.getNewValue();
            for (Regexp configuredRegexp : configuredRegexps) {
                NamedContext c;
                if (!configuredRegexp.isDifferent(c = contextStore.getContext(configuredRegexp.getName()))) continue;
                this.rebuildProject();
                return;
            }
        }
    }

    public static ProjectRebuilder getInstance(Project prj) {
        ProjectRebuilder instance = (ProjectRebuilder)prj.getUserData(PROJECT_REBUILDER_KEY);
        if (instance == null) {
            instance = new ProjectRebuilder(prj);
            prj.putUserData(PROJECT_REBUILDER_KEY, (Object)instance);
        }
        return instance;
    }

    public void rebuildProject() {
        this.rebuildProject(false);
    }

    public void rebuildProject(boolean cleanDb) {
        boolean rebuild;
        IdeaCloverConfig ideaCloverConfig = ProjectPlugin.getPlugin(this.project).getConfig();
        ProjectRebuild current = ideaCloverConfig.getProjectRebuild();
        if (current == ProjectRebuild.ASK) {
            RebuildProjectDialog rebuildProjectDialog = new RebuildProjectDialog(this.project, cleanDb);
            rebuildProjectDialog.show();
            rebuild = rebuildProjectDialog.rebuildRequested();
            if (!rebuildProjectDialog.askNextTime()) {
                ideaCloverConfig.setProjectRebuild(rebuild ? ProjectRebuild.ALWAYS : ProjectRebuild.NEVER);
            }
        } else {
            boolean bl = rebuild = current == ProjectRebuild.ALWAYS;
        }
        if (rebuild) {
            if (cleanDb) {
                ProjectPlugin.getPlugin(this.project).getCoverageManager().delete();
            }
            CompilerManager.getInstance((Project)this.project).rebuild(null);
        }
    }
}

