/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.build;

import com.atlassian.clover.idea.CloverModuleComponent;
import com.atlassian.clover.idea.IProjectPlugin;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.build.InclusionDetector;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.util.InclusionUtil;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class ProjectInclusionDetector
implements InclusionDetector {
    private boolean isIncluded;
    private boolean cloverDisabled;
    private boolean includeNotJava;
    private boolean notJava;
    private boolean moduleNotFound;
    private boolean moduleExcluded;
    private boolean pathNotFound;
    private boolean patternExcluded;
    private boolean inTestSources;

    public static InclusionDetector processFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        IProjectPlugin plugin = ProjectPlugin.getPlugin(project);
        return ProjectInclusionDetector.processFile(project, virtualFile, false, plugin.getConfig());
    }

    public static InclusionDetector processFileOrDir(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        IProjectPlugin plugin = ProjectPlugin.getPlugin(project);
        return ProjectInclusionDetector.processFile(project, virtualFile, true, plugin.getConfig());
    }

    static InclusionDetector processFile(@NotNull Project project, VirtualFile virtualFile, boolean ignoreType, @NotNull IdeaCloverConfig config) {
        ModuleRootManager rManager;
        Module module;
        ProjectInclusionDetector detector = new ProjectInclusionDetector();
        detector.includeNotJava = ignoreType;
        if (!config.isEnabled() || !config.isBuildWithClover()) {
            detector.cloverDisabled = true;
        }
        if (!FileTypeManager.getInstance().getFileTypeByFile(virtualFile).equals(StdFileTypes.JAVA)) {
            detector.notJava = true;
            if (!ignoreType) {
                return detector;
            }
        }
        if ((module = ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project)) == null) {
            detector.moduleNotFound = true;
        } else {
            CloverModuleComponent c = CloverModuleComponent.getInstance(module);
            if (c != null && c.getConfig().isExcluded()) {
                detector.moduleExcluded = true;
                return detector;
            }
        }
        String javaPath = VfsUtil.getRootRelativeFilename(project, virtualFile);
        if (javaPath == null) {
            detector.pathNotFound = true;
            return detector;
        }
        if (!InclusionUtil.isIncluded(javaPath, InclusionUtil.toArray(config.getExcludes(), " ,"), InclusionUtil.toArray(config.getIncludes(), " ,"), true)) {
            detector.patternExcluded = true;
            return detector;
        }
        if (!config.isInstrumentTests() && (rManager = ModuleRootManager.getInstance((Module)module)).getFileIndex().isInTestSourceContent(virtualFile)) {
            detector.inTestSources = true;
            return detector;
        }
        detector.isIncluded = true;
        return detector;
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public boolean isModuleExcluded() {
        return this.moduleExcluded;
    }

    @Override
    public boolean isPathNotFound() {
        return this.pathNotFound;
    }

    @Override
    public boolean isPatternExcluded() {
        return this.patternExcluded;
    }

    @Override
    public boolean isInNoninstrumentedTestSources() {
        return this.inTestSources;
    }

    @Override
    public boolean isCloverDisabled() {
        return this.cloverDisabled;
    }

    @Override
    public boolean isNotJava() {
        return this.notJava;
    }

    @Override
    public boolean isModuleNotFound() {
        return this.moduleNotFound;
    }
}

