/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.autoupdater;

import com.atlassian.clover.idea.autoupdater.LatestVersionInfo;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.panels.VerticalBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class NewVersionDialog
extends DialogWrapper {
    public static final int SKIP_VERSION_EXIT_CODE = 2;
    private JTextPane releaseNotes = new JTextPane();
    private JLabel title = new JLabel();
    private HyperlinkLabel releaseNotesLink = new HyperlinkLabel("Release Notes");

    public NewVersionDialog(final LatestVersionInfo version) {
        super(false);
        this.setOKButtonText("Yes");
        this.setCancelButtonText("Not now");
        this.setTitle(CloverIdeaPluginMessages.getString("autoupdate.updatingplugin"));
        this.title.setIcon(CloverIcons.CLOVER_BIG);
        this.title.setText(CloverIdeaPluginMessages.getFormattedString("autoupdate.newversionavailable", version.getNumber(), "4.5.1"));
        this.title.setIconTextGap(10);
        this.releaseNotes.setContentType("text/html");
        this.releaseNotes.setText(version.getReleaseNotes());
        this.releaseNotes.setCaretPosition(0);
        this.releaseNotes.setEditable(false);
        this.releaseNotes.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserUtil.browse((URL)e.getURL());
                }
            }
        });
        this.releaseNotesLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserUtil.browse((String)version.getReleaseNotesUrl());
                }
            }
        });
        this.init();
    }

    protected JComponent createNorthPanel() {
        return this.title;
    }

    protected JComponent createCenterPanel() {
        VerticalBox box = new VerticalBox();
        box.add(Box.createVerticalStrut(10));
        box.add((Component)new JScrollPane(this.releaseNotes));
        box.add(Box.createVerticalStrut(10));
        JPanel linkBox = new JPanel(new BorderLayout());
        linkBox.add((Component)new JPanel(), "Center");
        linkBox.add((Component)this.releaseNotesLink, "East");
        linkBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, linkBox.getPreferredSize().height));
        box.add((Component)linkBox);
        box.setPreferredSize(new Dimension(600, 400));
        return box;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), new AbstractAction(){
            {
                this.putValue("Name", "Skip this version");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                NewVersionDialog.this.close(2);
            }
        }};
    }
}

