/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.autoupdater;

import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.util.NetUtil;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.util.IOStreamUtils;
import com.intellij.ide.startup.StartupActionScriptManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.ClassPathUtil;

public class CloverPluginDownloader
extends Task.Backgroundable {
    private final String downloadUrl;
    private final Logger LOG = Logger.getInstance("CloverPluginDownloader");
    private File tempFile;

    public CloverPluginDownloader(String downloadUrl) {
        super(null, CloverIdeaPluginMessages.getString("autoupdate.downloading"));
        this.downloadUrl = downloadUrl;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        block11: {
            BufferedOutputStream os = null;
            BufferedInputStream is = null;
            try {
                this.tempFile = FileUtil.createTempFile((String)"clover_plugin", (String)".download");
                this.tempFile.deleteOnExit();
                try {
                    os = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                }
                catch (FileNotFoundException e) {
                    this.tempFile.delete();
                    throw e;
                }
                try {
                    is = new BufferedInputStream(NetUtil.openUrlStream(this.downloadUrl));
                }
                catch (IOException e) {
                    IOStreamUtils.close(os);
                    this.tempFile.delete();
                    throw e;
                }
                int b = ((InputStream)is).read();
                while (b != -1) {
                    ((OutputStream)os).write(b);
                    if (indicator.isCanceled()) {
                        indicator.checkCanceled();
                    }
                    b = ((InputStream)is).read();
                }
                IOStreamUtils.close(is);
                IOStreamUtils.close(os);
                File downloadedFile = new File(new URL(this.downloadUrl).getPath());
                String currentPath = ClassPathUtil.getCloverJarPath();
                File currentFile = new File(currentPath);
                if (!currentFile.isFile() || !currentFile.exists()) {
                    throw new RuntimeException(CloverIdeaPluginMessages.getFormattedString("autoupdate.wrongcurrentlocation", currentPath));
                }
                File newFile = downloadedFile.getName().equals(currentFile.getName()) ? new File(currentFile.getParent(), "_" + downloadedFile.getName()) : new File(currentFile.getParent(), downloadedFile.getName());
                this.LOG.info("Copying " + this.tempFile + " to " + newFile);
                FileUtil.copy((File)this.tempFile, (File)newFile);
                this.LOG.info("Scheduling deletion of " + currentFile);
                StartupActionScriptManager.addActionCommand((StartupActionScriptManager.ActionCommand)new StartupActionScriptManager.DeleteCommand(currentFile));
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CloverPluginDownloader.this.onTrueSuccess();
                    }
                });
            }
            catch (Exception e) {
                boolean isCancelled = e instanceof ProcessCanceledException;
                if (!isCancelled) {
                    Logger.getInstance().info("Exception during new version download", e);
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CloverPluginDownloader.this.onFailure(e);
                        }
                    });
                }
                IOStreamUtils.close(os);
                IOStreamUtils.close(is);
                if (this.tempFile != null) {
                    this.tempFile.delete();
                }
                if (!isCancelled) break block11;
                throw (ProcessCanceledException)e;
            }
        }
    }

    protected void onFailure(Exception ex) {
    }

    protected void onTrueSuccess() {
    }
}

