/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea.actions.excludes;

import com.atlassian.clover.idea.util.InclusionUtil;
import com.atlassian.clover.idea.util.vfs.VfsUtil;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openclover.util.Lists;

public abstract class ExclusionUtil {
    static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile != null) {
            virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null || !FileTypeManager.getInstance().getFileTypeByFile(virtualFile).equals(StdFileTypes.JAVA)) {
                return null;
            }
        } else if (element instanceof PsiDirectory) {
            virtualFile = ((PsiDirectory)element).getVirtualFile();
        } else {
            return null;
        }
        return virtualFile;
    }

    static boolean isEnabled(PsiElement element, Project project) {
        if (element instanceof PsiPackage) {
            return true;
        }
        VirtualFile virtualFile = ExclusionUtil.getVirtualFile(element);
        return virtualFile != null && ModuleUtil.findModuleForFile((VirtualFile)virtualFile, (Project)project) != null;
    }

    public static String getPattern(@Nullable PsiElement element) {
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName().replace('.', '/') + "/*.java";
        }
        VirtualFile virtualFile = ExclusionUtil.getVirtualFile(element);
        if (element == null || virtualFile == null) {
            return null;
        }
        Project project = element.getProject();
        String relativePath = VfsUtil.getRootRelativeFilename(project, virtualFile);
        return relativePath == null ? null : (virtualFile.isDirectory() ? relativePath + "*.java" : relativePath);
    }

    public static String getRecursivePattern(@Nullable PsiElement element) {
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName().replace('.', '/') + "/**";
        }
        VirtualFile virtualFile = ExclusionUtil.getVirtualFile(element);
        if (element == null || virtualFile == null || !virtualFile.isDirectory()) {
            return null;
        }
        Project project = element.getProject();
        String relativePath = VfsUtil.getRootRelativeFilename(project, virtualFile);
        return relativePath == null ? null : relativePath + "**";
    }

    public static boolean isExplicitlyIncluded(String config, String pattern) {
        String[] includes;
        for (String include : includes = InclusionUtil.toArray(config, " ,")) {
            if (!include.equals(pattern)) continue;
            return true;
        }
        return false;
    }

    public static String removePattern(String existing, String pattern) {
        boolean modified = false;
        ArrayList<String> tokens = Lists.newArrayList(InclusionUtil.toArray(existing, " ,"));
        Iterator i = tokens.iterator();
        while (i.hasNext()) {
            String token = (String)i.next();
            if (!token.trim().equals(pattern)) continue;
            modified = true;
            i.remove();
        }
        if (modified) {
            String separator = "";
            StringBuilder sb = new StringBuilder();
            for (String token : tokens) {
                sb.append(separator);
                sb.append(token);
                separator = ", ";
            }
            return sb.toString();
        }
        return existing;
    }

    public static String getDisplayName(@NotNull String pattern) {
        int idx = pattern.indexOf(42);
        String name = idx == -1 ? pattern : pattern.substring(0, idx);
        return name.length() > 0 ? name : "<default>";
    }
}

