/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.ui.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class MyHyperlinkListener
implements HyperlinkListener {
    MyHyperlinkListener() {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = e.getURL();
            if ("file".equals(url.getProtocol())) {
                this.displayFile(url);
            } else {
                BrowserUtil.browse((URL)url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayFile(URL url) {
        String title = url.getHost() + " license";
        String path = url.getPath();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path), StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        int read = 0;
        try {
            try {
                while (read != -1) {
                    sb.append(buf, 0, read);
                    read = reader.read(buf);
                }
            }
            finally {
                ((Reader)reader).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Messages.showMessageDialog((String)sb.toString(), (String)title, null);
    }
}

