/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.reporters.filters.DefaultTestFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public class IdeaTestFilter
extends DefaultTestFilter {
    protected final Project project;

    protected IdeaTestFilter(boolean inverted, @NotNull Project project) {
        super(inverted);
        this.project = project;
    }

    public IdeaTestFilter(@NotNull Project project) {
        this(false, project);
    }

    @Override
    public IdeaTestFilter invert() {
        return new IdeaTestFilter(!this.isInverted(), this.project);
    }

    protected boolean isInTestFolder(File file) {
        VirtualFile virtualFile;
        try {
            virtualFile = VfsUtil.findFileByURL((URL)file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot convert File to VirtualFile (" + file + ")", e);
        }
        return virtualFile != null && ProjectRootManager.getInstance((Project)this.project).getFileIndex().isInTestSourceContent(virtualFile);
    }

    @Override
    public boolean accept(HasMetrics hasMetrics) {
        FullClassInfo classInfo;
        File file;
        if (hasMetrics instanceof FullClassInfo && this.isInTestFolder(file = ((FullFileInfo)(classInfo = (FullClassInfo)hasMetrics).getContainingFile()).getPhysicalFile())) {
            return !this.isInverted();
        }
        return super.accept(hasMetrics);
    }
}

