/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.idea.NodeWrapperSelectionListener;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.ConfigChangeEvent;
import com.atlassian.clover.idea.config.ConfigChangeListener;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.coverage.CoverageNodeViewer;
import com.atlassian.clover.idea.coverage.CoverageTreeModel;
import com.atlassian.clover.idea.coverageview.CoverageViewPanel;
import com.atlassian.clover.idea.report.jfc.WarningBox;
import com.atlassian.clover.idea.util.ModelScope;
import com.atlassian.clover.idea.util.ui.BorderLayoutConverter;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class CloverToolWindow
extends JPanel
implements ConfigChangeListener,
NodeWrapperSelectionListener {
    private static final Logger LOG = Logger.getInstance((String)CloverToolWindow.class.getName());
    private ToolWindow toolWindow;
    private ActionToolbar toolbar;
    private CoverageViewPanel coveragePane;
    private JPanel coverageSummaryPanel;
    private CoverageNodeViewer coverageNodeViewer;
    private WarningBox warningBox;
    private final Project project;
    private static final Key<CloverToolWindow> WINDOW_PROJECT_KEY = Key.create((String)CloverToolWindow.class.getName());

    public static CloverToolWindow getInstance(Project project) {
        CloverToolWindow window = (CloverToolWindow)project.getUserData(WINDOW_PROJECT_KEY);
        if (window == null) {
            window = new CloverToolWindow(project);
            project.putUserData(WINDOW_PROJECT_KEY, (Object)window);
        }
        return window;
    }

    private CloverToolWindow(Project project) {
        this.project = project;
        this.initComponents();
        this.initListeners();
    }

    @Override
    public void configChange(ConfigChangeEvent evt) {
        PropertyChangeEvent propertyChange;
        if (evt.hasPropertyChange("showSummaryInToolwindow")) {
            propertyChange = evt.getPropertyChange("showSummaryInToolwindow");
            boolean show = (Boolean)propertyChange.getNewValue();
            this.getCoverageSummaryPanel().setVisible(show);
        }
        if (evt.hasPropertyChange("enabled")) {
            propertyChange = evt.getPropertyChange("enabled");
            boolean enabled = (Boolean)propertyChange.getNewValue();
            if (this.toolWindow != null) {
                this.toolWindow.setAvailable(enabled, null);
            }
        }
        if (evt.hasPropertyChange("modelScope")) {
            propertyChange = evt.getPropertyChange("modelScope");
            ModelScope scope = (ModelScope)((Object)propertyChange.getNewValue());
            this.updateCoverageNodeViewScope(scope);
        }
    }

    private void updateCoverageNodeViewScope(ModelScope scope) {
        this.getCoverageNodeViewer().setTestMethodsVisible(scope == ModelScope.ALL_CLASSES || scope == ModelScope.TEST_CLASSES_ONLY);
    }

    private void initComponents() {
        this.setLayout(new BorderLayoutConverter(this));
        this.setBorder(new EmptyBorder(2, 2, 2, 2));
        Container c = new Container();
        c.setLayout(new BorderLayout());
        c.add((Component)this.getToolBar(), "North");
        c.add((Component)this.getCoveragePane(), "Center");
        this.add((Component)c, "Center");
        this.add((Component)this.getCoverageSummaryPanel(), "South");
        this.getCoverageSummaryPanel().setVisible(this.getConfig().isShowSummaryInToolwindow());
    }

    private void initListeners() {
        IdeaCloverConfig config = this.getConfig();
        config.addConfigChangeListener(this);
        this.updateCoverageNodeViewScope(config.getModelScope());
        this.getCoveragePane().addElementSelectionListener(this);
    }

    @Override
    public void elementSelected(CoverageTreeModel.NodeWrapper wrapper) {
        if (wrapper == null) {
            this.getCoverageNodeViewer().clearNode();
            this.getWarningBox().setVisible(false);
        } else {
            HasMetrics hasMetrics = wrapper.getHasMetrics();
            this.getCoverageNodeViewer().setNode(hasMetrics, wrapper.getTestPassInfo());
            try {
                FullFileInfo fileInfo = null;
                if (hasMetrics instanceof FullClassInfo) {
                    fileInfo = (FullFileInfo)((FullClassInfo)hasMetrics).getContainingFile();
                } else if (hasMetrics instanceof FullFileInfo) {
                    fileInfo = (FullFileInfo)hasMetrics;
                }
                if (fileInfo != null && !fileInfo.validatePhysicalFile()) {
                    this.getWarningBox().setMessage("Coverage data for " + fileInfo.getPhysicalFile().getName() + " is out of date.");
                    this.getWarningBox().setVisible(true);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CloverToolWindow.this.getCoveragePane().ensureSelectionVisible();
                        }
                    });
                } else {
                    this.getWarningBox().setVisible(false);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                this.getWarningBox().setVisible(false);
            }
        }
    }

    private IdeaCloverConfig getConfig() {
        return ProjectPlugin.getPlugin(this.project).getConfig();
    }

    private JComponent getToolBar() {
        if (this.toolbar == null) {
            ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("CloverToolBar");
            this.toolbar = ActionManager.getInstance().createActionToolbar("Clover", actionGroup, true);
        }
        return this.toolbar.getComponent();
    }

    private CoverageViewPanel getCoveragePane() {
        if (this.coveragePane == null) {
            this.coveragePane = new CoverageViewPanel(this.project, "Cloverage");
        }
        return this.coveragePane;
    }

    private JComponent getCoverageSummaryPanel() {
        if (this.coverageSummaryPanel == null) {
            this.coverageSummaryPanel = new JPanel(new BorderLayout());
            JPanel middlePopups = new JPanel(new BorderLayout());
            middlePopups.add((Component)this.getWarningBox(), "Center");
            this.coverageSummaryPanel.add((Component)middlePopups, "North");
            this.coverageSummaryPanel.add((Component)this.getCoverageNodeViewer().getPane(), "Center");
        }
        return this.coverageSummaryPanel;
    }

    private CoverageNodeViewer getCoverageNodeViewer() {
        if (this.coverageNodeViewer == null) {
            this.coverageNodeViewer = new CoverageNodeViewer();
        }
        return this.coverageNodeViewer;
    }

    private WarningBox getWarningBox() {
        if (this.warningBox == null) {
            this.warningBox = new WarningBox();
            this.warningBox.setVisible(false);
        }
        return this.warningBox;
    }

    public boolean isRegistered() {
        return this.toolWindow != null;
    }

    public void register() {
        if (this.isRegistered()) {
            return;
        }
        ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.project);
        this.toolWindow = toolWindowManager.registerToolWindow("Cloverage", false, ToolWindowAnchor.LEFT);
        ContentManager contentManager = this.toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this, null, false);
        contentManager.addContent(content);
        this.toolWindow.setIcon(CloverIcons.TOOL_WINDOW);
        this.toolWindow.setAvailable(this.getConfig().isEnabled(), null);
    }

    public void cleanup() {
        this.unregister();
    }

    private void unregister() {
        if (!this.isRegistered()) {
            return;
        }
        ToolWindowManager tManager = ToolWindowManager.getInstance((Project)this.project);
        tManager.unregisterToolWindow("Cloverage");
        this.toolWindow = null;
    }
}

