/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.CloverStartup;
import com.atlassian.clover.Logger;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.CloverGlobalConfig;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import org.jetbrains.annotations.NotNull;

@State(name="Clover", storages={@Storage(id="other", file="$APP_CONFIG$/other.xml")})
public class CloverPlugin
implements ApplicationComponent,
PersistentStateComponent<CloverGlobalConfig> {
    private final Logger LOG;
    private CloverGlobalConfig globalConfig = new CloverGlobalConfig();

    public static CloverPlugin getPlugin() {
        return (CloverPlugin)ApplicationManager.getApplication().getComponent(CloverPlugin.class);
    }

    public CloverPlugin() {
        Logger.setFactory(new Logger.Factory(){

            @Override
            public Logger getLoggerInstance(String category) {
                return new IdeaLogger(com.intellij.openapi.diagnostic.Logger.getInstance((String)category));
            }
        });
        this.LOG = Logger.getInstance(CloverPlugin.class.getName());
    }

    @NotNull
    public String getComponentName() {
        return "Clover";
    }

    public void initComponent() {
        CloverStartup.logVersionInfo(this.LOG);
        this.LOG.info("Plugin Version 4.5.1");
        this.activateCloverForProjects();
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup compilerPopupMenu = (DefaultActionGroup)actionManager.getAction("CompilerErrorViewPopupMenu");
        if (compilerPopupMenu == null) {
            compilerPopupMenu = new DefaultActionGroup();
            actionManager.registerAction("CompilerErrorViewPopupMenu", (AnAction)compilerPopupMenu);
        }
        AnAction action = actionManager.getAction("CloverPlugin.JumpToActualSource");
        compilerPopupMenu.add(action, Constraints.LAST);
    }

    public void disposeComponent() {
    }

    protected void activateCloverForProjects() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            IdeaCloverConfig cloverConfig = ProjectPlugin.getPlugin(project).getConfig();
            cloverConfig.setEnabled(true);
            cloverConfig.notifyListeners();
        }
    }

    public CloverGlobalConfig getState() {
        return this.globalConfig;
    }

    public void loadState(CloverGlobalConfig state) {
        this.globalConfig = new CloverGlobalConfig();
    }

    public class IdeaLogger
    extends Logger {
        private com.intellij.openapi.diagnostic.Logger ideaLog;

        public IdeaLogger(com.intellij.openapi.diagnostic.Logger ideaLog) {
            this.ideaLog = ideaLog;
        }

        @Override
        public void log(int level, String aMsg, Throwable t) {
            switch (level) {
                case 3: 
                case 4: {
                    this.ideaLog.debug(aMsg);
                    if (t == null) break;
                    this.ideaLog.debug(t);
                    break;
                }
                case 2: {
                    this.ideaLog.info(aMsg);
                    if (t == null) break;
                    this.ideaLog.info(t);
                    break;
                }
                case 1: {
                    this.ideaLog.warn(aMsg, t);
                    break;
                }
                case 0: {
                    if (t != null) {
                        this.ideaLog.error(aMsg, t);
                        break;
                    }
                    this.ideaLog.error(aMsg);
                    break;
                }
                default: {
                    this.ideaLog.debug("<unknown log level> " + aMsg);
                }
            }
        }
    }
}

