/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.idea;

import com.atlassian.clover.idea.MyHyperlinkListener;
import com.atlassian.clover.idea.ProjectPlugin;
import com.atlassian.clover.idea.config.IdeaCloverConfig;
import com.atlassian.clover.idea.util.l10n.CloverIdeaPluginMessages;
import com.atlassian.clover.idea.util.ui.CloverIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.IdeBorderFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.Nullable;

public class AboutDialog
extends DialogWrapper {
    private final Project project;
    private JTabbedPane tabs;
    private final JCheckBox enabledCheckbox = new JCheckBox("Enable for current project");
    private static final MessageFormat LICENSE_ROW = new MessageFormat("<td><a href=\"{1}\">{0}</a></td><td align=\"right\"><a href=\"file://{0}/licenses/{2}\">License</a></td>\n");

    public AboutDialog(Project project) {
        super(project, false);
        this.project = project;
        if (project != null) {
            this.enabledCheckbox.setSelected(ProjectPlugin.getPlugin(project).getConfig().isEnabled());
        } else {
            this.enabledCheckbox.setSelected(false);
            this.enabledCheckbox.setEnabled(false);
        }
        this.init();
    }

    protected void doOKAction() {
        if (this.project != null) {
            IdeaCloverConfig cloverConfig = ProjectPlugin.getPlugin(this.project).getConfig();
            cloverConfig.setEnabled(this.enabledCheckbox.isSelected());
            cloverConfig.notifyListeners();
        }
        super.doOKAction();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.tabs = new JTabbedPane();
        this.tabs.addTab("Installation", this.getInstallationPanel());
        this.tabs.addTab("Acknowledgements", this.getAcknowledgementsPanel());
        return this.tabs;
    }

    private Component getInstallationPanel() {
        return AboutDialog.makeEditorPane(this.getInstallationText());
    }

    private Component getAcknowledgementsPanel() {
        return AboutDialog.makeEditorPane(this.getAcknowledgementsText());
    }

    private static JEditorPane makeEditorPane(String contents) {
        JEditorPane panel = new JEditorPane("text/html", contents);
        panel.setEditable(false);
        panel.setOpaque(false);
        panel.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        panel.addHyperlinkListener(new MyHyperlinkListener());
        return panel;
    }

    private String getAcknowledgementsText() {
        StringBuffer sb = new StringBuffer("<p>OpenClover is based on open source code of Atlassian Clover&reg;</p>");
        sb.append("<p>OpenClover makes use of the following 3rd party libraries:</p>");
        sb.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\">");
        this.addRow(sb, this.addProduct("Annotations (IntelliJ)", "https://www.jetbrains.com", "ANNOTATIONS-13.0-LICENSE.TXT"), this.addProduct("Ant", "https://ant.apache.org", "ANT-1.5.2-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("ANTLR2 Library", "https://www.antlr2.org", "ANTLR-2.7.7-LICENSE.TXT"), this.addProduct("ANTLR3 Java Grammar", "https://www.antlr3.org", "ANTLR-JAVA-GRAMMAR-3.0-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("Cajo", "https://java.net/projects/cajo/pages/Home", "CAJO-1.117-LICENSE.TXT"), this.addProduct("Commons Codec", "https://commons.apache.org", "COMMONS-CODEC-1.9-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("Commons Collections", "https://commons.apache.org", "COMMONS-COLLECTIONS-3.2.2-LICENSE.TXT"), this.addProduct("Commons Lang", "https://commons.apache.org", "COMMONS-LANG3-3.3.2-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("FastUtil", "https://fastutil.dsi.unimi.it/", "FASTUTIL-4.4.3-LICENSE.TXT"), this.addProduct("Groovy", "https://groovy.codehaus.org", "GROOVY-1.7.0-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("GSON", "https://code.google.com/p/google-gson", "GSON-1.3-LICENSE.TXT"), this.addProduct("", "", ""));
        this.addRow(sb, this.addProduct("iText", "https://itextpdf.com", "ITEXT-2.0.1-LICENSE.TXT"), this.addProduct("JCommon", "https://www.jfree.org/jfreechart/", "JCOMMON-1.0.23-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("JDOM", "https://www.jdom.org/", "JDOM-1.0-LICENSE.TXT"), this.addProduct("JFreeChart", "https://www.jfree.org/jfreechart/", "JFREECHART-1.0.19-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("JTreemap", "https://jtreemap.sourceforge.net/", "JTREEMAP-1.1.0-LICENSE.TXT"), this.addProduct("JIT", "https://thejit.org/", "JIT-1.1.2-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("JSON", "https://www.json.org", "JSON-LICENSE.TXT"), this.addProduct("jQuery", "https://jquery.com", "JQUERY-1.8.3-LICENSE.TXT"));
        this.addRow(sb, this.addProduct("SLF4J", "https://www.slf4j.org", "SLF4J-1.7.36-LICENSE.TXT"), this.addProduct("Velocity", "https://velocity.apache.org/", "VELOCITY-1.7-LICENSE.TXT"));
        this.addRow(sb, "<td colspan=\"4\">OpenClover also reuses some icons from:</td>");
        this.addRow(sb, this.addProduct("IntelliJ IDEA", "http://www.jetbrains.com/", "INTELLIJ-9.0-ICONS-LICENSE.TXT"), "<td colspan=\"2\">&nbsp;</td>");
        sb.append("</table>");
        sb.append("<p>This product includes software developed by the<br/>Apache Software Foundation (<a href=\"http://www.apache.org/\">http://www.apache.org/</a>)</p>");
        return sb.toString();
    }

    private void addRow(StringBuffer sb, String ... cells) {
        sb.append("<tr>");
        for (String cell : cells) {
            sb.append(cell);
        }
        sb.append("</tr>");
    }

    private String addProduct(String name, String url, String license) {
        return LICENSE_ROW.format(new Object[]{name, url, license});
    }

    private String getInstallationText() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\">");
        this.addRow(sb, "<td>Version:</td>", "<td>4.5.1</td>");
        this.addRow(sb, "<td colspan=\"2\">" + CloverIdeaPluginMessages.getString("clover.copyright") + "</td>");
        sb.append("</table>");
        return sb.toString();
    }

    protected JComponent createSouthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)super.createSouthPanel(), "East");
        this.enabledCheckbox.setVerticalAlignment(0);
        this.enabledCheckbox.setBorder(IdeBorderFactory.createEmptyBorder((Insets)new Insets(SystemInfo.isMacOSLeopard ? 8 : 16, 0, 0, 0)));
        panel.add((Component)this.enabledCheckbox, "West");
        return panel;
    }

    protected JComponent createNorthPanel() {
        JLabel label = new JLabel("", CloverIcons.CLOVER_LOGO, 0);
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 10));
        return label;
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction()};
    }
}

