/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing.provider;

import clover.net.sf.jtreemap.swing.ColorProvider;
import clover.net.sf.jtreemap.swing.JTreeMap;
import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.Value;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;

public class RandomColorProvider
extends ColorProvider {
    private static final long serialVersionUID = -8184356270950978553L;
    private static final Color[] COLOURS = new Color[]{new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 255, 0), new Color(255, 0, 255), new Color(0, 255, 255), new Color(102, 102, 51), new Color(255, 51, 153), new Color(255, 153, 51), new Color(204, 204, 51), new Color(205, 102, 204), new Color(51, 153, 255), new Color(153, 102, 0)};
    private int cursor = 0;
    private final TreeMap<Value, Color> mapping = new TreeMap();
    private JPanel legend;
    private JTreeMap jTreeMap;

    public RandomColorProvider(JTreeMap jTreeMap) {
        this.jTreeMap = jTreeMap;
    }

    public Color getColor(Value value) {
        if (!this.mapping.containsKey(value)) {
            this.mapping.put(value, COLOURS[this.cursor]);
            ++this.cursor;
            if (this.cursor == COLOURS.length) {
                this.cursor = 0;
            }
        }
        return this.mapping.get(value);
    }

    void setValues(TreeMapNode root) {
        if (root.isLeaf()) {
            Value value = root.getValue();
            this.getColor(value);
        } else {
            Enumeration<TreeNode> e = root.children();
            while (e.hasMoreElements()) {
                TreeMapNode node = (TreeMapNode)e.nextElement();
                this.setValues(node);
            }
        }
    }

    public JPanel getLegendPanel() {
        if (this.legend == null) {
            this.legend = new Legend();
        }
        return this.legend;
    }

    protected class Legend
    extends JPanel {
        private static final int OFFSET = 3;
        private static final int X_OFFSET = 15;
        private static final int INITIAL_X_POS = 20;
        private static final long serialVersionUID = 4652239358357480113L;
        private int x = 20;
        private static final int Y = 25;
        private static final int WIDTH = 10;
        private static final int HEIGHT = 20;

        protected Legend() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (RandomColorProvider.this.mapping.isEmpty()) {
                RandomColorProvider.this.setValues(RandomColorProvider.this.jTreeMap.getRoot());
            }
            FontMetrics fm = g.getFontMetrics();
            int yString = 25 + (20 + fm.getAscent() - fm.getDescent()) / 2;
            this.x = 20;
            for (Value value : RandomColorProvider.this.mapping.keySet()) {
                Color color = (Color)RandomColorProvider.this.mapping.get(value);
                g.setColor(color);
                g.fillRect(this.x, 25, 10, 20);
                g.setColor(Color.black);
                this.x = this.x + 10 + 3;
                g.drawString(value.getLabel(), this.x, yString);
                this.x = this.x + fm.stringWidth(value.getLabel()) + 15;
            }
            this.setPreferredSize(new Dimension(this.x, 70));
            this.setSize(this.getPreferredSize());
        }
    }
}

