/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing.example;

import clover.net.sf.jtreemap.swing.TreeMapNode;
import clover.net.sf.jtreemap.swing.TreeMapNodeBuilder;
import clover.net.sf.jtreemap.swing.ValuePercent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BuilderXML {
    private static final String BRANCH = "branch";
    private static final String LEAF = "leaf";
    private static final String LABEL = "label";
    private static final String WEIGHT = "weight";
    private static final String VALUE = "value";
    private Document document;
    private TreeMapNodeBuilder builder = new TreeMapNodeBuilder();

    public BuilderXML(String stFileName) throws ParseException {
        this.parse(new File(stFileName));
    }

    public BuilderXML(File stFile) throws ParseException {
        this.parse(stFile);
    }

    public BuilderXML(InputStream stream) throws ParseException {
        this.parse(stream);
    }

    public TreeMapNode getRoot() {
        return this.builder.getRoot();
    }

    private void build(Element elmt, TreeMapNode parent) throws ParseException {
        TreeMapNode tmn = null;
        if (elmt.getElementsByTagName(LABEL).getLength() == 0) {
            throw new ParseException("The file don't correspond to the TreeMap.dtd", 0);
        }
        String label = ((Element)elmt.getElementsByTagName(LABEL).item(0)).getChildNodes().item(0).getNodeValue();
        tmn = this.builder.buildBranch(label, parent);
        NodeList children = elmt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String childName = child.getTagName();
            if (BRANCH.equals(childName)) {
                this.build(child, tmn);
                continue;
            }
            if (!LEAF.equals(childName)) continue;
            NodeList labels = child.getElementsByTagName(LABEL);
            label = ((Element)labels.item(0)).getChildNodes().item(0).getNodeValue();
            NodeList values = child.getElementsByTagName(VALUE);
            String valueString = ((Element)values.item(0)).getChildNodes().item(0).getNodeValue();
            NodeList weights = child.getElementsByTagName(WEIGHT);
            String weightString = ((Element)weights.item(0)).getChildNodes().item(0).getNodeValue();
            ValuePercent value = new ValuePercent(Double.valueOf(valueString));
            double weight = Double.valueOf(weightString);
            this.builder.buildLeaf(label, weight, value, tmn);
        }
    }

    private void parse(File stFile) throws ParseException {
        try {
            DocumentBuilderFactory fabrique = DocumentBuilderFactory.newInstance();
            DocumentBuilder constructeur = fabrique.newDocumentBuilder();
            this.document = constructeur.parse(stFile);
            Element root = this.document.getDocumentElement();
            this.build(root, null);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("The file don't correspond to the TreeMap.dtd (" + e.getMessage() + ")", 0);
        }
        catch (SAXException e) {
            throw new ParseException("The file don't correspond to the TreeMap.dtd (" + e.getMessage() + ")", 0);
        }
        catch (IOException e) {
            throw new ParseException("The file don't correspond to the TreeMap.dtd (" + e.getMessage() + ")", 0);
        }
    }

    private void parse(InputStream stream) throws ParseException {
        try {
            DocumentBuilderFactory fabrique = DocumentBuilderFactory.newInstance();
            DocumentBuilder constructeur = fabrique.newDocumentBuilder();
            this.document = constructeur.parse(stream);
            Element root = this.document.getDocumentElement();
            this.build(root, null);
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("The file don't correspond to the TreeMap.dtd (" + e.getMessage() + ")", 0);
        }
        catch (SAXException e) {
            throw new ParseException("The file don't correspond to the TreeMap.dtd (" + e.getMessage() + ")", 0);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ParseException("The file don't correspond to the TreeMap.dtd (" + e.getMessage() + ")", 0);
        }
    }
}

