/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing;

import clover.net.sf.jtreemap.swing.TreeMapNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SplitStrategy
implements Serializable {
    public void calculatePositions(TreeMapNode root) {
        if (root == null) {
            return;
        }
        Vector<TreeMapNode> v = root.getChildren();
        if (v != null) {
            this.calculatePositionsRec(root.getX(), root.getY(), root.getWidth(), root.getHeight(), this.sumWeight(v), v);
        }
    }

    public abstract void splitElements(Vector<TreeMapNode> var1, Vector<TreeMapNode> var2, Vector<TreeMapNode> var3);

    public double sumWeight(Vector<TreeMapNode> v) {
        double d = 0.0;
        if (v != null) {
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                d += v.elementAt(i).getWeight();
            }
        }
        return d;
    }

    protected void calculatePositionsRec(int x0, int y0, int w0, int h0, double weight0, Vector<TreeMapNode> v) {
        if (v.size() == 1) {
            TreeMapNode f = v.elementAt(0);
            if (f.isLeaf()) {
                int h;
                int w = w0 - TreeMapNode.getBorder();
                if (w < 0) {
                    w = 0;
                }
                if ((h = h0 - TreeMapNode.getBorder()) < 0) {
                    h = 0;
                }
                f.setDimension(x0 + TreeMapNode.getBorder(), y0 + TreeMapNode.getBorder(), w, h);
            } else {
                int h;
                f.setDimension(x0, y0, w0, h0);
                int bSub = TreeMapNode.getBorder() > 1 ? 2 : (TreeMapNode.getBorder() == 1 ? 1 : 0);
                int w = w0 - bSub;
                if (w < 0) {
                    w = 0;
                }
                if ((h = h0 - bSub) < 0) {
                    h = 0;
                }
                TreeMapNode.setBorder(TreeMapNode.getBorder() - bSub);
                this.calculatePositionsRec(x0 + bSub, y0 + bSub, w, h, weight0, f.getChildren());
                TreeMapNode.setBorder(TreeMapNode.getBorder() + bSub);
            }
        } else {
            int y2;
            int x2;
            int h2;
            int h1;
            int w2;
            int w1;
            Vector<TreeMapNode> v1 = new Vector<TreeMapNode>();
            Vector<TreeMapNode> v2 = new Vector<TreeMapNode>();
            this.splitElements(v, v1, v2);
            double weight1 = this.sumWeight(v1);
            double weight2 = this.sumWeight(v2);
            if (w0 > h0) {
                w1 = (int)((double)w0 * weight1 / weight0);
                w2 = w0 - w1;
                h1 = h0;
                h2 = h0;
                x2 = x0 + w1;
                y2 = y0;
            } else {
                w1 = w0;
                w2 = w0;
                h1 = (int)((double)h0 * weight1 / weight0);
                h2 = h0 - h1;
                x2 = x0;
                y2 = y0 + h1;
            }
            this.calculatePositionsRec(x0, y0, w1, h1, weight1, v1);
            this.calculatePositionsRec(x2, y2, w2, h2, weight2, v2);
        }
    }

    protected void sortVector(Vector<TreeMapNode> v) {
        for (int i = 0; i < v.size(); ++i) {
            for (int j = v.size() - 1; j > i; --j) {
                if (!(v.elementAt(j).getWeight() > v.elementAt(j - 1).getWeight())) continue;
                TreeMapNode tmn = v.elementAt(j);
                v.setElementAt(v.elementAt(j - 1), j);
                v.setElementAt(tmn, j - 1);
            }
        }
    }

    protected void workOutWeight(Vector<TreeMapNode> v1, Vector<TreeMapNode> v2, Vector<TreeMapNode> vClone, double sumWeight) {
        double memWeight = 0.0;
        double elemWeight = 0.0;
        Iterator<TreeMapNode> i = vClone.iterator();
        while (i.hasNext()) {
            TreeMapNode tmn = i.next();
            elemWeight = tmn.getWeight();
            if (memWeight + elemWeight >= sumWeight / 2.0) {
                if (sumWeight / 2.0 - memWeight > memWeight + elemWeight - sumWeight / 2.0) {
                    memWeight += elemWeight;
                    v1.addElement(tmn);
                } else if (v1.isEmpty()) {
                    v1.addElement(tmn);
                } else {
                    v2.addElement(tmn);
                }
                while (i.hasNext()) {
                    tmn = i.next();
                    v2.addElement(tmn);
                }
                continue;
            }
            memWeight += elemWeight;
            v1.addElement(tmn);
        }
    }
}

