/*
 * Decompiled with CFR 0.152.
 */
package clover.net.sf.jtreemap.swing;

import clover.net.sf.jtreemap.swing.JTreeMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JToolTip;

public class DefaultToolTip
extends JToolTip {
    private static final int TOOLTIP_OFFSET = 5;
    private static final int DEFAULT_VALUE_SIZE = 10;
    private static final int DEFAULT_LABEL_SIZE = 12;
    private static final long serialVersionUID = -2492627777999093973L;
    private JTreeMap jTreeMap;
    private Font labelFont;
    private Font valueFont;
    private String weightPrefix;
    private String valuePrefix;
    private boolean showWeight;

    public DefaultToolTip(JTreeMap jTreeMap, String weightPrefix, String valuePrefix, boolean showWeight) {
        this.jTreeMap = jTreeMap;
        this.weightPrefix = weightPrefix;
        this.valuePrefix = valuePrefix;
        this.showWeight = showWeight;
        this.labelFont = new Font("Default", 1, 12);
        this.valueFont = new Font("Default", 0, 10);
        int width = 160;
        int height = this.getFontMetrics(this.labelFont).getHeight() + this.getFontMetrics(this.valueFont).getHeight();
        Dimension size = new Dimension(160, height);
        this.setSize(size);
        this.setPreferredSize(size);
    }

    public void paint(Graphics g) {
        if (this.jTreeMap.getActiveLeaf() != null) {
            Graphics g2D = g;
            g2D.setColor(Color.YELLOW);
            g2D.fill3DRect(0, 0, this.getWidth(), this.getHeight(), true);
            g2D.setColor(Color.black);
            g2D.setFont(this.labelFont);
            g2D.drawString(this.jTreeMap.getActiveLeaf().getLabel(), 5, g2D.getFontMetrics(this.labelFont).getAscent());
            g2D.setFont(this.valueFont);
            String toDraw = this.jTreeMap.getActiveLeaf().getLabelValue();
            if (this.valuePrefix != null) {
                toDraw = this.valuePrefix + " " + toDraw;
            }
            if (this.showWeight) {
                toDraw = this.jTreeMap.getActiveLeaf().getWeight() + ", " + toDraw;
            }
            if (this.weightPrefix != null && this.showWeight) {
                toDraw = this.weightPrefix + " " + toDraw;
            }
            g2D.drawString(toDraw, 5, this.getHeight() - 5);
        }
    }
}

