/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.xml;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.command.ArgProcessor;
import com.atlassian.clover.api.command.HelpBuilder;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.LineInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.ClassMetrics;
import com.atlassian.clover.registry.metrics.FileMetrics;
import com.atlassian.clover.registry.metrics.PackageMetrics;
import com.atlassian.clover.registry.metrics.ProjectMetrics;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.CloverReporter;
import com.atlassian.clover.reporters.CommandLineArgProcessors;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.xml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class XMLReporter
extends CloverReporter {
    private static final List<ArgProcessor<Current>> mandatoryArgProcessors = Lists.newArrayList(CommandLineArgProcessors.InitString, CommandLineArgProcessors.OutputFile);
    private static final List<ArgProcessor<Current>> optionalArgProcessors = Lists.newArrayList(CommandLineArgProcessors.AlwaysReport, CommandLineArgProcessors.DebugLogging, CommandLineArgProcessors.Filter, CommandLineArgProcessors.IncludeFailedTestCoverage, CommandLineArgProcessors.LineInfo, CommandLineArgProcessors.Span, CommandLineArgProcessors.ShowInnerFunctions, CommandLineArgProcessors.ShowLambdaFunctions, CommandLineArgProcessors.Title, CommandLineArgProcessors.ThreadCount, CommandLineArgProcessors.VerboseLogging);
    private static final List<ArgProcessor<Current>> allArgProcessors = Lists.join(mandatoryArgProcessors, optionalArgProcessors);
    private ContextSet contextSet;

    public XMLReporter(CloverReportConfig config) throws CloverException {
        this(config.getCoverageDatabase(), config);
    }

    public XMLReporter(CloverDatabase database, CloverReportConfig config) {
        super(database, config);
        this.contextSet = database.getContextSet(this.reportConfig.getFormat().getFilter());
    }

    @Override
    public int executeImpl() throws CloverException {
        block3: {
            try {
                if (this.reportConfig.isAlwaysReport() || this.database.hasCoverage()) break block3;
                Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
                return 1;
            }
            catch (IOException e) {
                throw new CloverException("IO Exception: " + e.getMessage());
            }
        }
        XMLWriter out = this.initWriter();
        Logger.getInstance().info("Writing report to '" + this.reportConfig.getOutFile() + "'");
        out.writeXMLDecl();
        HashMap<String, String> attribs = Maps.newHashMap();
        attribs.put("clover", "4.5.0");
        attribs.put("generated", String.valueOf(System.currentTimeMillis()));
        out.writeElementStart("coverage", attribs);
        this.writeProject(out, "project", this.database.getAppOnlyModel());
        this.writeProject(out, "testproject", this.database.getTestOnlyModel());
        out.writeElementEnd("coverage");
        out.close();
        return 0;
    }

    private XMLWriter initWriter() throws IOException {
        File outFile = this.reportConfig.getOutFile();
        if (outFile.getParent() != null && !outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        BufferedOutputStream os = this.reportConfig.isCompress() ? new BufferedOutputStream(new GZIPOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]))) : new BufferedOutputStream(Files.newOutputStream(outFile.toPath(), new OpenOption[0]));
        return new XMLWriter(os, "UTF-8");
    }

    private void writeProject(XMLWriter out, String enclosingTag, FullProjectInfo proj) throws IOException {
        HashMap<String, String> attribs = Maps.newHashMap();
        if (this.reportConfig.getTitle() != null) {
            attribs.put("name", this.reportConfig.getTitle());
        }
        long ts = this.database.getRecordingTimestamp();
        if (this.reportConfig.getEffectiveDate() != null) {
            ts = this.reportConfig.getEffectiveDate().getTime();
        }
        attribs.put("timestamp", String.valueOf(ts));
        out.writeElementStart(enclosingTag, attribs);
        this.writeMetrics(out, proj.getMetrics());
        List<? extends PackageInfo> packages = proj.getAllPackages();
        if (packages.size() > 0) {
            boolean summaryReport = false;
            if (this.reportConfig instanceof Current) {
                summaryReport = ((Current)this.reportConfig).getSummary();
            }
            for (PackageInfo packageInfo : packages) {
                FullPackageInfo pkg = (FullPackageInfo)packageInfo;
                attribs = Maps.newHashMap();
                attribs.put("name", pkg.getName());
                out.writeElementStart("package", attribs);
                this.writeMetrics(out, pkg.getMetrics());
                if (!summaryReport) {
                    this.writeFilesForPkg(out, pkg);
                }
                out.writeElementEnd("package");
            }
        }
        out.writeElementEnd(enclosingTag);
    }

    private void writeMetrics(XMLWriter out, BlockMetrics metrics) throws IOException {
        HashMap<String, String> attribs = Maps.newHashMap();
        attribs.put("elements", String.valueOf(metrics.getNumElements()));
        attribs.put("statements", String.valueOf(metrics.getNumStatements()));
        attribs.put("conditionals", String.valueOf(metrics.getNumBranches()));
        attribs.put("coveredelements", String.valueOf(metrics.getNumCoveredElements()));
        attribs.put("coveredstatements", String.valueOf(metrics.getNumCoveredStatements()));
        attribs.put("coveredconditionals", String.valueOf(metrics.getNumCoveredBranches()));
        attribs.put("complexity", String.valueOf(metrics.getComplexity()));
        if (metrics instanceof ClassMetrics) {
            ClassMetrics cm = (ClassMetrics)metrics;
            attribs.put("methods", String.valueOf(cm.getNumMethods()));
            attribs.put("coveredmethods", String.valueOf(cm.getNumCoveredMethods()));
            if (metrics.getNumTestsRun() > 0 && !(metrics instanceof FileMetrics)) {
                attribs.put("testpasses", String.valueOf(metrics.getNumTestPasses()));
                attribs.put("testfailures", String.valueOf(metrics.getNumTestFailures()));
                attribs.put("testruns", String.valueOf(metrics.getNumTestsRun()));
                attribs.put("testduration", String.valueOf(metrics.getTestExecutionTime()));
            }
            if (metrics instanceof FileMetrics) {
                FileMetrics fm = (FileMetrics)metrics;
                attribs.put("classes", String.valueOf(fm.getNumClasses()));
                attribs.put("loc", String.valueOf(fm.getLineCount()));
                attribs.put("ncloc", String.valueOf(fm.getNcLineCount()));
                if (metrics instanceof PackageMetrics) {
                    PackageMetrics pm = (PackageMetrics)metrics;
                    attribs.put("files", String.valueOf(pm.getNumFiles()));
                    if (metrics instanceof ProjectMetrics) {
                        ProjectMetrics pjm = (ProjectMetrics)metrics;
                        attribs.put("packages", String.valueOf(pjm.getNumPackages()));
                    }
                }
            }
        }
        out.writeElement("metrics", attribs);
    }

    private void writeFilesForPkg(XMLWriter out, FullPackageInfo pkg) throws IOException {
        List<? extends FileInfo> files = pkg.getFiles();
        for (FileInfo fileInfo : files) {
            FullFileInfo file = (FullFileInfo)fileInfo;
            HashMap<String, String> attribs = Maps.newHashMap();
            attribs.put("name", file.getName());
            attribs.put("path", file.getPhysicalFile().getAbsolutePath());
            out.writeElementStart("file", attribs);
            this.writeMetrics(out, file.getMetrics());
            this.writeClassesForFile(out, file.getClasses());
            if (this.reportConfig.getFormat().getSrcLevel()) {
                this.writeLineInfo(out, file);
            }
            out.writeElementEnd("file");
        }
    }

    private void writeClassesForFile(XMLWriter out, List<? extends ClassInfo> classes) throws IOException {
        for (ClassInfo classInfo : classes) {
            FullClassInfo info = (FullClassInfo)classInfo;
            HashMap<String, String> attribs = Maps.newHashMap();
            attribs.put("name", info.getName());
            out.writeElementStart("class", attribs);
            this.writeMetrics(out, info.getMetrics());
            out.writeElementEnd("class");
        }
    }

    private void writeLineInfo(XMLWriter out, FullFileInfo finfo) throws IOException {
        int linecount = finfo.getLineCount();
        LineInfo[] linfo = finfo.getLineInfo(((Current)this.reportConfig).isShowLambdaFunctions(), ((Current)this.reportConfig).isShowInnerFunctions());
        int i = 1;
        while (i <= linecount) {
            LineInfo info = linfo[i];
            if (linfo[i] != null) {
                FullBranchInfo[] branches;
                FullStatementInfo[] stmts;
                int n;
                FullMethodInfo[] starts = info.getMethodStarts();
                if (starts.length > 0) {
                    FullMethodInfo[] fullMethodInfoArray = starts;
                    n = starts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FullMethodInfo start = fullMethodInfoArray[n2];
                        if (!start.isFiltered(this.contextSet)) {
                            FullClassInfo clazz;
                            TestCaseInfo tci;
                            HashMap<String, String> attribs = Maps.newHashMap();
                            attribs.put("num", String.valueOf(i));
                            attribs.put("type", "method");
                            attribs.put("visibility", start.getVisibility());
                            attribs.put("count", String.valueOf(start.getHitCount()));
                            attribs.put("complexity", String.valueOf(start.getComplexity()));
                            attribs.put("signature", XMLWriter.escapeAttributeValue(start.getName()));
                            if (start.isTest() && (tci = (clazz = (FullClassInfo)start.getContainingClass()).getTestCase(String.valueOf(clazz.getQualifiedName()) + "." + start.getSimpleName())) != null && tci.isHasResult()) {
                                attribs.put("testsuccess", XMLWriter.escapeAttributeValue("" + tci.isSuccess()));
                                attribs.put("testduration", XMLWriter.escapeAttributeValue(String.valueOf(tci.getDuration())));
                            }
                            out.writeElement("line", attribs);
                        }
                        ++n2;
                    }
                }
                if ((stmts = info.getStatements()).length > 0) {
                    FullStatementInfo[] fullStatementInfoArray = stmts;
                    int n3 = stmts.length;
                    n = 0;
                    while (n < n3) {
                        FullStatementInfo stmt = fullStatementInfoArray[n];
                        if (!stmt.isFiltered(this.contextSet)) {
                            HashMap<String, String> attribs = Maps.newHashMap();
                            attribs.put("num", String.valueOf(i));
                            attribs.put("type", "stmt");
                            attribs.put("count", String.valueOf(stmt.getHitCount()));
                            out.writeElement("line", attribs);
                        }
                        ++n;
                    }
                }
                if ((branches = info.getBranches()).length > 0) {
                    FullBranchInfo[] fullBranchInfoArray = branches;
                    int n4 = branches.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        FullBranchInfo branch = fullBranchInfoArray[n5];
                        if (!branch.isFiltered(this.contextSet)) {
                            HashMap<String, String> attribs = Maps.newHashMap();
                            attribs.put("num", String.valueOf(i));
                            attribs.put("type", "cond");
                            attribs.put("truecount", String.valueOf(branch.getTrueHitCount()));
                            attribs.put("falsecount", String.valueOf(branch.getFalseHitCount()));
                            out.writeElement("line", attribs);
                        }
                        ++n5;
                    }
                }
            }
            ++i;
        }
    }

    private static CloverReportConfig processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_XML);
        try {
            int i = 0;
            while (i < args.length) {
                for (ArgProcessor<Current> argProcessor : allArgProcessors) {
                    if (!argProcessor.matches(args, i)) continue;
                    i = argProcessor.process(args, i, cfg);
                }
                ++i;
            }
            if (!cfg.validate()) {
                XMLReporter.usage(cfg.getValidationFailureReason());
                cfg = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            XMLReporter.usage("Missing a parameter.");
            cfg = null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println(HelpBuilder.buildHelp(XMLReporter.class, mandatoryArgProcessors, optionalArgProcessors));
        System.err.println();
    }

    public static void main(String[] args) {
        XMLReporter.loadLicense();
        System.exit(XMLReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        CloverReportConfig config = XMLReporter.processArgs(args);
        if (XMLReporter.canProceedWithReporting(config)) {
            try {
                return new XMLReporter(config).execute();
            }
            catch (CloverException e) {
                Logger.getInstance().error("An error occurred while generating the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }
}

