/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.json.JSONArray;
import com.atlassian.clover.reporters.json.JSONObject;
import com.atlassian.clover.reporters.json.JSONReportUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public class RenderColophonJSONAction
implements Callable {
    private final VelocityContext ctx;
    private final File file;
    private final CloverReportConfig cfg;

    public RenderColophonJSONAction(VelocityContext ctx, File file, CloverReportConfig cfg) {
        this.ctx = ctx;
        this.file = file;
        this.cfg = cfg;
    }

    public Object call() throws Exception {
        this.file.getParentFile().mkdirs();
        JSONObject json = new JSONObject().put("clover", new JSONObject().put("release", "4.5.0").put("build", new JSONObject().put("date", "2023-10-04").put("stamp", 20231004093535L))).put("report", new JSONObject().put("stamp", Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSS").format(new Date(System.currentTimeMillis())))).put("mode", "static").put("callback", this.cfg.getFormat().getCallback()).put("columns", this.selectedColumns()));
        this.ctx.put("json", json);
        this.ctx.put("callback", "");
        HtmlReportUtil.mergeTemplateToFile(this.file, this.ctx, "api-json.vm");
        return Void.TYPE;
    }

    private JSONArray selectedColumns() {
        JSONArray jsonColumns = new JSONArray();
        List columnNames = JSONReportUtils.getColumnNames(this.cfg);
        for (Object columnName : columnNames) {
            jsonColumns.put(columnName);
        }
        return jsonColumns;
    }
}

