/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.org.apache.commons.lang3.StringUtils;
import clover.org.apache.velocity.VelocityContext;
import clover.org.jfree.chart.ChartRenderingInfo;
import clover.org.jfree.chart.ChartUtilities;
import clover.org.jfree.chart.JFreeChart;
import com.atlassian.clover.CloverLicenseInfo;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.command.ArgProcessor;
import com.atlassian.clover.api.command.HelpBuilder;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.PackageFragment;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.CloverReporter;
import com.atlassian.clover.reporters.CommandLineArgProcessors;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.Historical;
import com.atlassian.clover.reporters.TestSelectionHelper;
import com.atlassian.clover.reporters.Type;
import com.atlassian.clover.reporters.filters.SourceFileFilter;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.RenderDashboardAction;
import com.atlassian.clover.reporters.html.RenderFileAction;
import com.atlassian.clover.reporters.html.RenderPackageCoverageCloudAction;
import com.atlassian.clover.reporters.html.RenderPackageSummaryAction;
import com.atlassian.clover.reporters.html.RenderPackageTreeJsonAction;
import com.atlassian.clover.reporters.html.RenderProjectCoverageCloudsAction;
import com.atlassian.clover.reporters.html.RenderTestResultAction;
import com.atlassian.clover.reporters.json.JSONHistoricalReporter;
import com.atlassian.clover.reporters.json.RenderMetricsJSONAction;
import com.atlassian.clover.reporters.json.RenderTreeMapAction;
import com.atlassian.clover.reporters.util.CloverChartFactory;
import com.atlassian.clover.reporters.util.HistoricalReportDescriptor;
import com.atlassian.clover.util.CloverExecutor;
import com.atlassian.clover.util.CloverExecutors;
import com.atlassian.clover.util.CloverUtils;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.format.HtmlFormatter;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class HtmlReporter
extends CloverReporter {
    private static final List<ArgProcessor<Current>> mandatoryArgProcessors = Lists.newArrayList(CommandLineArgProcessors.InitString, CommandLineArgProcessors.OutputDirHtml);
    private static final List<ArgProcessor<Current>> optionalArgProcessors = Lists.newArrayList(CommandLineArgProcessors.AlwaysReport, CommandLineArgProcessors.HideBars, CommandLineArgProcessors.BlackAndWhite, CommandLineArgProcessors.OrderBy, CommandLineArgProcessors.DebugLogging, CommandLineArgProcessors.ShowEmpty, CommandLineArgProcessors.Filter, CommandLineArgProcessors.HideSources, CommandLineArgProcessors.IncludeFailedTestCoverage, CommandLineArgProcessors.NoCache, CommandLineArgProcessors.SourcePath, CommandLineArgProcessors.Span, CommandLineArgProcessors.ShowInnerFunctions, CommandLineArgProcessors.ShowLambdaFunctions, CommandLineArgProcessors.ShowUnique, CommandLineArgProcessors.Title, CommandLineArgProcessors.ThreadCount, CommandLineArgProcessors.TabWidth, CommandLineArgProcessors.VerboseLogging);
    private static final List<ArgProcessor<Current>> allArgProcessors = Lists.join(mandatoryArgProcessors, optionalArgProcessors);
    private static final Map<String, String> HTML_HOMEPAGE_VALUES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("overview", "pkg-summary.html");
            this.put("aggregate", "agg-pkgs.html");
            this.put(HtmlReporter.HTML_HOMEPAGE_DEFAULT, "dashboard.html");
            this.put("quickwins", "quick-wins.html");
            this.put("projectrisks", "proj-risks.html");
            this.put("testresults", "test-pkg-summary.html");
        }
    });
    private static final String HTML_HOMEPAGE_DEFAULT = "dashboard";
    protected static final Map<String, String> SUMMARY_TABS = Collections.unmodifiableMap(new LinkedHashMap<String, String>(){
        {
            this.put(HtmlReporter.TAB_CLASSES, "pkg-app.html");
            this.put(HtmlReporter.TAB_TESTS, "pkg-test.html");
            this.put(HtmlReporter.TAB_RESULTS, "pkg-results.html");
        }
    });
    protected static final String TAB_CLASSES = "Classes";
    protected static final String TAB_TESTS = "Tests";
    protected static final String TAB_RESULTS = "Results";
    private static final Comparator TEST_SORT_ORDER = HasMetricsSupport.newTestListComparator();
    private static final Comparator<TestCaseInfo> TEST_CASE_COMPARATOR = new Comparator<TestCaseInfo>(){

        @Override
        public int compare(TestCaseInfo lhs, TestCaseInfo rhs) {
            if (rhs.isSuccess() & lhs.isSuccess()) {
                return 0;
            }
            if (!rhs.isSuccess()) {
                return 1;
            }
            return -1;
        }
    };
    private final DateFormat dateFormat = new SimpleDateFormat("EEE MMM d yyyy HH:mm:ss z");
    private final File basePath;
    private final File baseImagePath;
    private final HtmlRenderingSupportImpl rederingHelper = new HtmlRenderingSupportImpl(this.reportConfig.getFormat(), true);
    private final String reportTimeStamp;
    private final Comparator listComparator;
    private final String pageTitle;
    private final String pageTitleAnchor;
    private final String pageTitleTarget;
    private Date coverageTS;
    private Comparator detailComparator;

    public HtmlReporter(CloverReportConfig config) throws CloverException {
        super(config);
        this.basePath = this.reportConfig.getOutFile();
        this.baseImagePath = new File(this.basePath, "img");
        this.reportTimeStamp = this.dateFormat.format(new Date(System.currentTimeMillis()));
        this.pageTitleAnchor = config.getTitleAnchor() != null ? config.getTitleAnchor() : "";
        this.pageTitleTarget = config.getTitleTarget() != null ? config.getTitleTarget() : "_top";
        this.pageTitle = config.getTitle();
        String comp = config.getFormat().getOrderby();
        this.listComparator = HasMetricsSupport.LEX_COMP;
        this.detailComparator = HasMetricsSupport.PC_ASCENDING_COMP;
        if (comp != null) {
            this.detailComparator = HasMetricsSupport.getHasMetricsComparator(comp);
        }
    }

    @Override
    protected void validate() throws CloverException {
        super.validate();
        if (!this.isCurrentReport() && !this.isHistoricalReport()) {
            throw new CloverException("Unsupported report type: " + this.reportConfig.getClass().getName());
        }
    }

    @Override
    protected int executeImpl() throws CloverException {
        try {
            CloverUtils.createDir(this.basePath);
            CloverUtils.createDir(this.baseImagePath);
            if (this.isCurrentReport()) {
                this.executeCurrentReport();
            } else if (this.isHistoricalReport()) {
                this.executeHistoricalReport();
            } else {
                throw new CloverException("No report type specified");
            }
            return 0;
        }
        catch (Exception e) {
            throw new CloverException(e);
        }
    }

    private void filterLinkedReports() {
        LinkedHashMap<String, CloverReportConfig> filteredLinkedReports = Maps.newLinkedHashMap();
        for (Map.Entry<String, CloverReportConfig> linkedReport : this.reportConfig.getLinkedReports().entrySet()) {
            CloverReportConfig linkedConfig = linkedReport.getValue();
            if (!linkedConfig.validate()) {
                Logger.getInstance().warn("Not linking report due to: " + linkedConfig.getValidationFailureReason());
                continue;
            }
            Format format = linkedConfig.getFormat();
            if (!format.in(Type.HTML, Type.PDF, Type.TEXT)) continue;
            filteredLinkedReports.put(linkedReport.getKey(), linkedConfig);
        }
        this.reportConfig.setLinkedReports(filteredLinkedReports);
    }

    private void executeCurrentReport() throws Exception {
        if (!this.reportConfig.isAlwaysReport() && !this.database.hasCoverage()) {
            Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
        } else {
            Logger.getInstance().info("Writing HTML report to '" + this.basePath + "'");
            this.coverageTS = new Date(this.database.getRecordingTimestamp());
            this.filterLinkedReports();
            long currentStartTime = System.currentTimeMillis();
            List<? extends PackageInfo> allPackages = this.getFullModel().getAllPackages();
            this.getFullModel().buildCaches();
            TreeInfo appSrcTree = new TreeInfo("", "App");
            TreeInfo appCloudTree = new TreeInfo("", "AppCloud");
            TreeInfo testSrcTree = new TreeInfo("testsrc-", "Test");
            try {
                List<? extends BaseClassInfo> targetClasses = this.getConfiguredModel().getClasses(HasMetricsFilter.ACCEPT_ALL);
                this.getTestModel().getClasses(HasMetricsFilter.ACCEPT_ALL);
                List targetFiles = this.getFullModel().getFiles(new SourceFileFilter());
                Map<Integer, CloverChartFactory.ChartInfo> srcFileCharts = CloverChartFactory.generateSrcFileCharts(targetFiles, this.baseImagePath);
                CloverExecutor service = CloverExecutors.newCloverExecutor(this.reportAsCurrent().getNumThreads(), "Clover");
                RenderFileAction.initThreadLocals();
                RenderMetricsJSONAction.initThreadLocals();
                for (PackageInfo packageInfo : allPackages) {
                    FullPackageInfo pkg = (FullPackageInfo)packageInfo;
                    Logger.getInstance().verbose("Processing package " + pkg.getName());
                    long start = System.currentTimeMillis();
                    this.processPackage(pkg, appSrcTree, appCloudTree, testSrcTree, service, srcFileCharts);
                    long total = System.currentTimeMillis() - start;
                    if (!Logger.isDebug()) continue;
                    Logger.getInstance().debug("Processed package: " + pkg.getName() + " (" + pkg.getClasses().size() + " classes, " + pkg.getMetrics().getNumTests() + " tests)" + " in " + total + "ms");
                }
                this.renderPackageNodesTree(service);
                this.renderDashboard(service, CloverChartFactory.generateHistogramChart(targetClasses, this.baseImagePath), CloverChartFactory.generateScatterChart(targetClasses, this.baseImagePath));
                this.renderProjectCoverageCloudPage(appCloudTree, service);
                this.renderProjectTreeMapPage(service);
                this.renderBasePages();
                this.renderTestResultsPkgsSummaryPage();
                this.renderAggregatePkgPage(this.getConfiguredModel(), appSrcTree, true);
                this.renderPackagesSummaryPage(this.getConfiguredModel(), appSrcTree, true);
                this.renderAggregatePkgPage(this.getTestModel(), testSrcTree, false);
                this.renderPackagesSummaryPage(this.getTestModel(), testSrcTree, false);
                this.copyCommonResources();
                service.shutdown();
                Interval interval = this.reportAsCurrent().getTimeOut();
                if (!service.awaitTermination(interval.getValueInMillis(), TimeUnit.MILLISECONDS)) {
                    throw new CloverException("Timeout of '" + interval + "' reached during report generation. " + "Please increase this value and try again.");
                }
            }
            finally {
                RenderFileAction.resetThreadLocals();
                RenderMetricsJSONAction.resetThreadLocals();
            }
            long currentTotalTime = System.currentTimeMillis() - currentStartTime;
            int pkgCount = allPackages.size();
            long msPerPkg = pkgCount == 0 ? currentTotalTime : currentTotalTime / (long)pkgCount;
            Logger.getInstance().info("Done. Processed " + pkgCount + " packages in " + currentTotalTime + "ms (" + msPerPkg + "ms per package).");
        }
    }

    private void executeHistoricalReport() throws Exception {
        Logger.getInstance().info("Writing historical report to '" + this.basePath + "'");
        HistoricalReportDescriptor descriptor = new HistoricalReportDescriptor(this.reportConfig);
        boolean hasHistoricalData = descriptor.gatherHistoricalModels();
        if (!hasHistoricalData) {
            Logger.getInstance().warn("No historical data found. No HTML historical report can be generated.");
            return;
        }
        this.coverageTS = new Date(descriptor.getFirstTimestamp());
        this.filterLinkedReports();
        VelocityContext context = new VelocityContext();
        this.insertCommonPropsForHistorical(context, "");
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "style.css", context);
        File outfile = new File(this.basePath, this.reportConfig.getMainFileName());
        context.put("historical", descriptor);
        CloverReportConfig firstCurrentConfig = this.reportConfig.getFirstCurrentConfig();
        if (firstCurrentConfig != null) {
            String relToCurrentRoot = FileUtils.getRelativePath(outfile.getParentFile(), firstCurrentConfig.getMainOutFile().getParentFile(), "/");
            relToCurrentRoot = "".equals(relToCurrentRoot) ? "" : String.valueOf(relToCurrentRoot) + "/";
            context.put("relToCurrentRoot", relToCurrentRoot);
            Format format = firstCurrentConfig.getFormat();
            if (format != null) {
                context.put("showSrc", format.getSrcLevel());
            }
        }
        context.put("hasmetrics", descriptor.getSubjectMetrics());
        context.put("endTimestamp", this.dateFormat.format(new Date(descriptor.getLastTimestamp())));
        if (descriptor.showMovers()) {
            context.put("allAdded", descriptor.getAddedDescriptors());
            context.put("allMovers", descriptor.getMoversDescriptors());
        }
        context.put("colSpan", 6);
        this.copyCommonResources();
        File imgDir = this.createChartImageDir();
        Historical historical = (Historical)this.reportConfig;
        List charts = historical.getCharts();
        SortedMap data = descriptor.getHistoricalModels();
        ArrayList chartNames = Lists.newArrayList();
        HashMap imageMaps = Maps.newHashMap();
        int i = 0;
        while (i < charts.size()) {
            String chartName = "chart" + i + ".jpg";
            chartNames.add(chartName);
            Historical.Chart chart = (Historical.Chart)charts.get(i);
            JFreeChart jFreeChart = CloverChartFactory.createJFreeChart(chart, data);
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            ChartUtilities.saveChartAsJPEG(new File(imgDir, chartName), 1.0f, jFreeChart, chart.getWidth(), chart.getHeight(), renderingInfo);
            String imageMap = ChartUtilities.getImageMap(chartName, renderingInfo);
            imageMaps.put(chartName, imageMap);
            ++i;
        }
        context.put("imageMaps", imageMaps);
        context.put("chartNames", chartNames);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "historical.vm");
        if (historical.isJson()) {
            JSONHistoricalReporter jsonReporter = new JSONHistoricalReporter(this.reportConfig.getOutFile());
            jsonReporter.generateHistoricalJSON(context, data, this.pageTitle);
        }
        Logger.getInstance().info("Done.");
    }

    private Current reportAsCurrent() {
        return (Current)this.reportConfig;
    }

    static Current processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_HTML);
        try {
            int i = 0;
            while (i < args.length) {
                for (ArgProcessor<Current> argProcessor : allArgProcessors) {
                    if (!argProcessor.matches(args, i)) continue;
                    i = argProcessor.process(args, i, cfg);
                }
                ++i;
            }
            TestSelectionHelper.configureTestSelectionFilter(cfg, args);
            if (!cfg.validate()) {
                HtmlReporter.usage(cfg.getValidationFailureReason());
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            HtmlReporter.usage("Missing a parameter.");
            return null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println(HelpBuilder.buildHelp(HtmlReporter.class, mandatoryArgProcessors, optionalArgProcessors));
        System.err.println(TestSelectionHelper.getParamsUsage());
        System.err.println();
    }

    public static void main(String[] args) {
        HtmlReporter.loadLicense();
        System.exit(HtmlReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        Current cfg = HtmlReporter.processArgs(args);
        if (HtmlReporter.canProceedWithReporting(cfg)) {
            try {
                return new HtmlReporter(cfg).execute();
            }
            catch (Exception e) {
                Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    private VelocityContext insertCommonPropsForCurrent(VelocityContext context, String pkg) {
        return this.insertCommonProps(context, pkg);
    }

    private VelocityContext insertCommonPropsForHistorical(VelocityContext context, String pkg) {
        return this.insertCommonProps(context, pkg);
    }

    private VelocityContext insertCommonProps(VelocityContext context, String pkg) {
        context.put("fileUtils", FileUtils.getInstance());
        context.put("stringUtils", new StringUtils());
        context.put("rootRelPath", this.rederingHelper.getRootRelPath(pkg));
        context.put("pageTitle", this.pageTitle);
        String title = this.pageTitle != null ? this.pageTitle : "Clover";
        context.put("headerTitle", pkg.length() == 0 ? title : String.valueOf(title) + ": " + pkg);
        context.put("pageTitleIsLink", this.pageTitleAnchor != null && this.pageTitleAnchor.length() > 0);
        context.put("pageTitleAnchor", this.pageTitleAnchor);
        context.put("pageTitleTarget", this.pageTitleTarget);
        context.put("renderUtil", this.rederingHelper);
        context.put("startTimestamp", this.dateFormat.format(this.coverageTS));
        String cloverURL = "https://openclover.org";
        context.put("cloverURL", cloverURL);
        context.put("cloverReleaseNum", "4.5.0");
        context.put("reportTimestamp", this.reportTimeStamp);
        context.put("showEmpty", this.reportConfig.getFormat().getShowEmpty());
        context.put("showSrc", this.reportConfig.getFormat().getSrcLevel());
        context.put("showBars", this.reportConfig.getFormat().getShowBars());
        context.put("noCache", this.reportConfig.getFormat().getNoCache());
        context.put("expired", CloverLicenseInfo.EXPIRED);
        context.put("charset", this.reportConfig.getCharset());
        context.put("skipCoverageTreeMap", this.reportConfig.isSkipCoverageTreeMap());
        context.put("reportConfigLinkedReports", this.reportConfig.getLinkedReports());
        context.put("reportConfigOutFile", this.reportConfig.getOutFile());
        HtmlReporter.insertLicenseMessages(context);
        return context;
    }

    static void insertLicenseMessages(VelocityContext context) {
        String headerMsg = String.valueOf(CloverLicenseInfo.OWNER_STMT) + " ";
        String footerMsg = String.valueOf(CloverLicenseInfo.OWNER_STMT) + " ";
        if (CloverLicenseInfo.EXPIRED) {
            headerMsg = String.valueOf(headerMsg) + CloverLicenseInfo.POST_EXPIRY_STMT + " " + CloverLicenseInfo.CONTACT_INFO_STMT;
            footerMsg = String.valueOf(footerMsg) + CloverLicenseInfo.POST_EXPIRY_STMT;
        } else {
            headerMsg = String.valueOf(headerMsg) + CloverLicenseInfo.PRE_EXPIRY_STMT;
            footerMsg = String.valueOf(footerMsg) + CloverLicenseInfo.PRE_EXPIRY_STMT;
        }
        if (CloverLicenseInfo.EXPIRES && !CloverLicenseInfo.EXPIRED) {
            context.put("evalMsg", "This report was generated with an evaluation server license.  <a href=\"https://openclover.org\">Purchase Clover</a> or <a href=\"https://openclover.org/documentation\">configure your license.</a>");
        }
        context.put("headerMsg", HtmlFormatter.format(headerMsg));
        context.put("footerMsg", HtmlFormatter.format(footerMsg));
    }

    private void renderProjectCoverageCloudPage(TreeInfo appCloudTree, CloverExecutor service) throws Exception {
        VelocityContext cloudsContext = new VelocityContext();
        this.insertCommonPropsForCurrent(cloudsContext, "");
        service.submit(new RenderProjectCoverageCloudsAction(cloudsContext, this.reportConfig, this.basePath, appCloudTree, this.getConfiguredModel()));
    }

    private void renderProjectTreeMapPage(CloverExecutor service) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonPropsForCurrent(context, "");
        service.submit(new RenderTreeMapAction(context, this.reportConfig, this.basePath, this.getConfiguredModel()));
    }

    protected FullProjectInfo getConfiguredModel() {
        return this.database.getAppOnlyModel();
    }

    protected FullProjectInfo getFullModel() {
        return this.database.getFullModel();
    }

    protected FullProjectInfo getTestModel() {
        return this.database.getTestOnlyModel();
    }

    private void renderPackageNodesTree(CloverExecutor queue) throws Exception {
        VelocityContext ctx = new VelocityContext();
        this.insertCommonPropsForCurrent(ctx, "");
        RenderPackageTreeJsonAction action = new RenderPackageTreeJsonAction(ctx, this.basePath, this.getFullModel(), this.getConfiguredModel(), this.reportAsCurrent());
        queue.submit(action);
    }

    private void renderDashboard(CloverExecutor queue, CloverChartFactory.ChartInfo histogram, CloverChartFactory.ChartInfo scatter) throws Exception {
        VelocityContext ctx = new VelocityContext();
        this.insertCommonPropsForCurrent(ctx, "");
        FullProjectInfo configuredProject = this.getConfiguredModel();
        RenderDashboardAction action = new RenderDashboardAction(ctx, this.basePath, configuredProject, this.getFullModel(), histogram, scatter, this.reportAsCurrent());
        queue.submit(action);
        File outfile = new File(this.reportAsCurrent().getOutFile(), "project.js");
        RenderMetricsJSONAction jsonAction = new RenderMetricsJSONAction(ctx, configuredProject, this.reportAsCurrent(), outfile, this.rederingHelper);
        queue.submit(jsonAction);
    }

    private File createChartImageDir() {
        File imgDir = new File(this.basePath, "img");
        imgDir.mkdir();
        return imgDir;
    }

    private void copyCommonResources() throws IOException {
        String templatePath = HtmlReportUtil.getTemplatePath();
        this.copyCommonResourcesBoth(templatePath);
        this.copyStaticResource(templatePath, "aui/css/arrow.png");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.eot");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.svg");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.ttf");
        this.copyStaticResource(templatePath, "aui/css/atlassian-icons.woff");
        this.copyStaticResource(templatePath, "aui/css/aui.min.css");
        this.copyStaticResource(templatePath, "aui/css/aui-experimental.min.css");
        this.copyStaticResource(templatePath, "aui/css/aui-icon-close.png");
        this.copyStaticResource(templatePath, "aui/css/aui-icon-tools.gif");
        this.copyStaticResource(templatePath, "aui/css/aui-ie9.min.css");
        this.copyStaticResource(templatePath, "aui/css/aui-toolbar-24px.png");
        this.copyStaticResource(templatePath, "aui/css/bg-000-trans20.png");
        this.copyStaticResource(templatePath, "aui/css/bg-000-trans50.png");
        this.copyStaticResource(templatePath, "aui/css/bg-grippy.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-dropdown.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-dropdown-active.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-dropdown-active-d.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-dropdown-d.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-maximize.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-maximize-d.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-minimize.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-minimize-d.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-move.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-move-d.png");
        this.copyStaticResource(templatePath, "aui/css/core/icon-search.png");
        this.copyStaticResource(templatePath, "aui/css/fav_off_16.png");
        this.copyStaticResource(templatePath, "aui/css/fav_on_16.png");
        this.copyStaticResource(templatePath, "aui/css/fonts/atlassian-icons.eot");
        this.copyStaticResource(templatePath, "aui/css/fonts/atlassian-icons.svg");
        this.copyStaticResource(templatePath, "aui/css/fonts/atlassian-icons.ttf");
        this.copyStaticResource(templatePath, "aui/css/fonts/atlassian-icons.woff");
        this.copyStaticResource(templatePath, "aui/css/forms/icon-date.png");
        this.copyStaticResource(templatePath, "aui/css/forms/icon-help.png");
        this.copyStaticResource(templatePath, "aui/css/forms/icon-range.png");
        this.copyStaticResource(templatePath, "aui/css/forms/icon-required.png");
        this.copyStaticResource(templatePath, "aui/css/forms/icons_form.gif");
        this.copyStaticResource(templatePath, "aui/css/forms/icon-users.png");
        this.copyStaticResource(templatePath, "aui/css/icons/aui-icon-close.png");
        this.copyStaticResource(templatePath, "aui/css/icons/aui-icon-tools.gif");
        this.copyStaticResource(templatePath, "aui/css/icons/aui-message-icon-sprite.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-dropdown.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-dropdown-active.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-dropdown-active-d.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-dropdown-d.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-maximize.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-maximize-d.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-minimize.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-minimize-d.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-move.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-move-d.png");
        this.copyStaticResource(templatePath, "aui/css/icons/core/icon-search.png");
        this.copyStaticResource(templatePath, "aui/css/icons/forms/icon-date.png");
        this.copyStaticResource(templatePath, "aui/css/icons/forms/icon-help.png");
        this.copyStaticResource(templatePath, "aui/css/icons/forms/icon-range.png");
        this.copyStaticResource(templatePath, "aui/css/icons/forms/icon-required.png");
        this.copyStaticResource(templatePath, "aui/css/icons/forms/icon-users.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-close.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-close-inverted.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-error.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-error-white.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-generic.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-hint.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-info.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-success.png");
        this.copyStaticResource(templatePath, "aui/css/icons/messages/icon-warning.png");
        this.copyStaticResource(templatePath, "aui/css/images/arrow.png");
        this.copyStaticResource(templatePath, "aui/css/images/bg-000-trans20.png");
        this.copyStaticResource(templatePath, "aui/css/images/bg-000-trans50.png");
        this.copyStaticResource(templatePath, "aui/css/images/fav_off_16.png");
        this.copyStaticResource(templatePath, "aui/css/images/fav_on_16.png");
        this.copyStaticResource(templatePath, "aui/css/images/forms/icons_form.gif");
        this.copyStaticResource(templatePath, "aui/css/images/icons/aui-message-icon-sprite.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-close.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-close-inverted.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-error.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-error-white.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-generic.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-hint.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-info.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-success.png");
        this.copyStaticResource(templatePath, "aui/css/images/icons/messages/icon-warning.png");
        this.copyStaticResource(templatePath, "aui/css/images/wait.gif");
        this.copyStaticResource(templatePath, "aui/css/messages/icon-close.png");
        this.copyStaticResource(templatePath, "aui/css/messages/icon-close-inverted.png");
        this.copyStaticResource(templatePath, "aui/css/select2.png");
        this.copyStaticResource(templatePath, "aui/css/select2-spinner.gif");
        this.copyStaticResource(templatePath, "aui/css/select2x2.png");
        this.copyStaticResource(templatePath, "aui/css/toolbar/aui-toolbar-24px.png");
        this.copyStaticResource(templatePath, "aui/css/wait.gif");
        this.copyStaticResource(templatePath, "aui/js/aui.min.js");
        this.copyStaticResource(templatePath, "aui/js/aui-datepicker.min.js");
        this.copyStaticResource(templatePath, "aui/js/aui-experimental.min.js");
        this.copyStaticResource(templatePath, "aui/js/aui-soy.min.js");
        this.copyStaticResource(templatePath, "jquery-1.8.3.min.js");
        this.copyStaticResource(templatePath, "clover-tree.js");
        this.copyStaticResource(templatePath, "clover-descriptions.js");
    }

    private void copyCommonResourcesBoth(String templatePath) throws IOException {
        this.copyStaticResource(templatePath, "img/ajax-loader.gif");
        this.copyStaticResource(templatePath, "img/back.gif");
        this.copyStaticResource(templatePath, "img/clover.ico");
        this.copyStaticResource(templatePath, "img/clover_logo_large.png");
        this.copyStaticResource(templatePath, "img/collapse.gif");
        this.copyStaticResource(templatePath, "img/expand.gif");
        this.copyStaticResource(templatePath, "img/failure_gutter.gif");
        this.copyStaticResource(templatePath, "img/logo.gif");
        this.copyStaticResource(templatePath, "img/spacer.gif");
        this.copyStaticResource(templatePath, "img/treemap.gif");
        this.copyStaticResource(templatePath, "cloud.js");
        this.copyStaticResource(templatePath, "clover.js");
        this.copyStaticResource(templatePath, "jit.js");
    }

    private void copyStaticResource(String aLoadPath, String aName) throws IOException {
        File outfile = new File(this.basePath, aName);
        FileUtils.resourceToFile(this.getClass().getClassLoader(), String.valueOf(aLoadPath) + "/" + aName, outfile);
    }

    private void processPackage(FullPackageInfo pkg, TreeInfo appSrcTree, TreeInfo appCloudTree, TreeInfo testSrcTree, CloverExecutor queue, Map<Integer, CloverChartFactory.ChartInfo> charts) throws Exception {
        LinkedList testClasses;
        FullProjectInfo projectInfo = this.getFullModel();
        for (FileInfo fileInfo : pkg.getFiles()) {
            FullFileInfo file = (FullFileInfo)fileInfo;
            this.renderSourceFilePage(queue, charts, projectInfo, file);
            this.renderTestPages(queue, file);
        }
        FullPackageInfo fullPackageInfo = (FullPackageInfo)this.getConfiguredModel().getNamedPackage(pkg.getName());
        FullPackageInfo pkgTestInfo = (FullPackageInfo)this.getTestModel().getNamedPackage(pkg.getName());
        LinkedList linkedList = testClasses = pkgTestInfo != null ? pkgTestInfo.getClasses() : new LinkedList();
        if (fullPackageInfo != null) {
            this.renderPkgSummaryPage(fullPackageInfo, appSrcTree, true, pkgTestInfo != null, true, queue);
            this.renderPkgCloudPages(fullPackageInfo, appCloudTree, true, pkgTestInfo != null, queue);
            this.renderPkgTreeMapPage(fullPackageInfo, queue);
        }
        if (pkgTestInfo != null) {
            this.renderPkgSummaryPage(pkgTestInfo, testSrcTree, fullPackageInfo != null, true, false, queue);
        }
        this.renderTestResultsPkgSummaryPages(pkg, testClasses);
    }

    private void renderSourceFilePage(CloverExecutor queue, Map<Integer, CloverChartFactory.ChartInfo> charts, FullProjectInfo projectInfo, FullFileInfo file) throws Exception {
        if (this.reportConfig.getFormat().getSrcLevel()) {
            queue.submit(new RenderFileAction(file, this.rederingHelper, this.reportAsCurrent(), this.insertCommonPropsForCurrent(new VelocityContext(), file.getContainingPackage().getName()), this.database, projectInfo, charts));
        }
    }

    private void renderTestPages(CloverExecutor queue, BaseFileInfo file) throws Exception {
        List<? extends ClassInfo> classes = file.getClasses();
        for (ClassInfo classInfo : classes) {
            FullClassInfo clazz = (FullClassInfo)classInfo;
            if (!clazz.isTestClass()) continue;
            for (TestCaseInfo test : clazz.getTestCases()) {
                VelocityContext context = new VelocityContext();
                this.insertCommonPropsForCurrent(context, file.getContainingPackage().getName());
                RenderTestResultAction testResultRenderer = new RenderTestResultAction(test, this.rederingHelper, (Current)this.reportConfig, this.getConfiguredModel(), context, this.getFullModel(), this.database);
                queue.submit(testResultRenderer);
            }
        }
    }

    private void gatherAggregatePackages(Map<String, PackageFragment> pkgs, PackageFragment frag) {
        pkgs.put(frag.getQualifiedName(), frag);
        PackageFragment[] kids = frag.getChildren();
        int i = 0;
        while (kids != null && i < kids.length) {
            PackageFragment kid = kids[i];
            this.gatherAggregatePackages(pkgs, kid);
            ++i;
        }
    }

    private void renderAggregatePkgPage(FullProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        String filename = String.valueOf(tree.getPathPrefix()) + "agg-pkgs.html";
        File outfile = new File(this.basePath, filename);
        VelocityContext context = new VelocityContext();
        context.put("linkToClouds", linkToClouds);
        context.put("currentPageURL", filename);
        context.put("headerMetrics", model.getMetrics());
        context.put("headerMetricsRaw", model.getRawMetrics());
        context.put("projectInfo", model);
        context.put("appPagePresent", Boolean.TRUE);
        context.put("testPagePresent", Boolean.TRUE);
        HtmlReportUtil.addFilteredPercentageToContext(context, model);
        this.insertCommonPropsForCurrent(context, "");
        HashMap<String, PackageFragment> aggregatePkgs = Maps.newHashMap();
        PackageFragment[] packageFragmentArray = model.getPackageRoots();
        int n = packageFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            PackageFragment root = packageFragmentArray[n2];
            this.gatherAggregatePackages(aggregatePkgs, root);
            ++n2;
        }
        ArrayList kids = Lists.newArrayList(aggregatePkgs.values());
        Collections.sort(kids, this.detailComparator);
        context.put("packageFragments", kids);
        context.put("tree", tree);
        HtmlReportUtil.addColumnsToContext(context, this.reportConfig.getColumns().getPkgColumns(), model, kids);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "agg-pkgs.vm");
    }

    private void renderBasePages() throws Exception {
        File outfile = new File(this.basePath, this.reportConfig.getMainFileName());
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", this.reportConfig.getMainFileName());
        this.insertCommonPropsForCurrent(context, "");
        context.put("homepageURL", this.getHomepageValue());
        HtmlReportUtil.mergeTemplateToFile(outfile, context, this.reportConfig.getMainFileName());
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "style.css", context);
        HtmlReportUtil.mergeTemplateToDir(this.basePath, "tree.css", context);
    }

    private String getHomepageValue() {
        String homepageKey = this.reportConfig.getHomepage() != null ? this.reportConfig.getHomepage() : HTML_HOMEPAGE_DEFAULT;
        return HTML_HOMEPAGE_VALUES.containsKey(homepageKey) ? HTML_HOMEPAGE_VALUES.get(homepageKey) : homepageKey;
    }

    private void renderPackagesSummaryPage(String name, String templateName, VelocityContext context, FullProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        String filename = String.valueOf(tree.getPathPrefix()) + name;
        File outfile = new File(this.basePath, filename);
        context.put("currentPageURL", filename);
        List<? extends PackageInfo> packages = model.getAllPackages();
        Collections.sort(packages, this.detailComparator);
        this.insertCommonPropsForCurrent(context, "");
        context.put("linkToClouds", linkToClouds);
        context.put("projectInfo", model);
        context.put("headerMetrics", model.getMetrics());
        context.put("headerMetricsRaw", model.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, model);
        context.put("packages", packages);
        context.put("tree", tree);
        context.put("appPagePresent", Boolean.TRUE);
        context.put("testPagePresent", Boolean.TRUE);
        HtmlReportUtil.addColumnsToContext(context, this.reportConfig.getColumns().getPkgColumns(), model, packages);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, templateName);
    }

    private void renderPackagesSummaryPage(FullProjectInfo model, TreeInfo tree, boolean linkToClouds) throws Exception {
        this.renderPackagesSummaryPage("pkg-summary.html", "pkgs-summary.vm", new VelocityContext(), model, tree, linkToClouds);
    }

    private void renderTestResultsPkgsSummaryPage() throws Exception {
        File outfile = new File(this.basePath, "test-pkg-summary.html");
        VelocityContext context = new VelocityContext();
        FullProjectInfo projectInfo = this.getFullModel().copy(new HasMetricsFilter(){

            @Override
            public boolean accept(HasMetrics hm) {
                return !(hm instanceof BaseClassInfo) || ((BaseClassInfo)hm).isTestClass();
            }
        });
        List<? extends PackageInfo> packages = projectInfo.getAllPackages();
        Collections.sort(packages, TEST_SORT_ORDER);
        context.put("currentPageURL", outfile.getName());
        this.insertCommonPropsForCurrent(context, "");
        this.insertCommonTestProps(context, packages, "package", null, projectInfo, "test-pkg-summary.html", "Project", "Packages");
        context.put("projectInfo", projectInfo);
        context.put("topLevel", Boolean.TRUE);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "test-pkg-summary.vm");
    }

    private void renderPkgClassesPage(String outfileName, String templateName, FullPackageInfo pkg, List classes, VelocityContext context, String currentTabName, boolean isTests) throws Exception {
        File outdir = pkg != null ? CloverUtils.createOutDir(pkg, this.basePath) : this.basePath;
        Collections.sort(classes, this.listComparator);
        File outfile = new File(outdir, outfileName);
        context.put("currentPageURL", outfileName);
        String name = pkg != null ? pkg.getName() : "All Classes";
        this.insertCommonPropsForCurrent(context, name);
        context.put("packageInfo", pkg);
        context.put("classlist", classes);
        context.put("currentTabName", currentTabName);
        context.put("isTests", isTests);
        context.put("topLevel", pkg == null);
        context.put("title", TAB_CLASSES);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, templateName);
    }

    public static String renderHtmlBarTable(float pcCovered, int width, String customClass) throws Exception {
        return HtmlReporter.renderHtmlBarTable(pcCovered, width, customClass, "", "");
    }

    public static String renderHtmlBarTable(float pcCovered, int width, String customClass, String customBarPositive, String customBarNegative) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("empty", pcCovered < 0.0f);
        context.put("pccovered", Float.valueOf(pcCovered));
        context.put("sortValue", Float.valueOf(pcCovered));
        context.put("width", width);
        context.put("customClass", customClass);
        context.put("customBarPositive", customBarPositive);
        context.put("customBarNegative", customBarNegative);
        context.put("renderUtil", new HtmlRenderingSupportImpl());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
        HtmlReportUtil.getVelocityEngine().mergeTemplate(HtmlReportUtil.getTemplatePath("bar-graph.vm"), "ASCII", context, out);
        out.close();
        return baos.toString();
    }

    private void renderPkgSummaryPage(FullPackageInfo pkg, TreeInfo tree, boolean appPagePresent, boolean testPagePresent, boolean linkToClouds, CloverExecutor queue) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonPropsForCurrent(context, pkg.getName());
        queue.submit(new RenderPackageSummaryAction(context, this.basePath, this.reportConfig, pkg, this.detailComparator, tree, this.rederingHelper, appPagePresent, testPagePresent, linkToClouds));
    }

    private void renderPkgCloudPages(FullPackageInfo pkg, TreeInfo tree, boolean appPagePresent, boolean testPagePresent, CloverExecutor queue) throws Exception {
        VelocityContext context = new VelocityContext();
        this.insertCommonPropsForCurrent(context, pkg.getName());
        queue.submit(new RenderPackageCoverageCloudAction(context, this.reportConfig, this.basePath, tree, pkg, appPagePresent, testPagePresent));
    }

    private void renderPkgTreeMapPage(FullPackageInfo pkg, CloverExecutor queue) {
    }

    private void renderTestResultsPkgSummaryPages(@NotNull FullPackageInfo pkg, @NotNull List<? extends ClassInfo> classes) throws Exception {
        File outdir = CloverUtils.createOutDir(pkg, this.basePath);
        TestMethodFilter filter = new TestMethodFilter();
        for (ClassInfo classInfo : classes) {
            FullClassInfo fullClassInfo = (FullClassInfo)classInfo;
            FullClassInfo testClassInfo = fullClassInfo.copy((FullFileInfo)fullClassInfo.getContainingFile(), filter);
            this.renderTestClassSummaryPage(testClassInfo);
        }
        Collections.sort(classes, TEST_SORT_ORDER);
        File file = new File(outdir, "test-pkg-summary.html");
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", "test-pkg-summary.html");
        context.put("projectInfo", this.getFullModel());
        context.put("appModelPresent", this.getConfiguredModel().getNamedPackage(pkg.getName()) != null);
        context.put("testModelPresent", this.getTestModel().getNamedPackage(pkg.getName()) != null);
        this.insertCommonPropsForCurrent(context, pkg.getName());
        this.insertCommonTestProps(context, classes, "class", pkg, pkg, "test-pkg-summary.html", "Package", "Test Classes");
        HtmlReportUtil.mergeTemplateToFile(file, context, "test-pkg-summary.vm");
    }

    private void renderTestClassSummaryPage(@NotNull FullClassInfo classInfo) throws Exception {
        String outname = this.rederingHelper.getTestClassLink(false, classInfo);
        File outfile = CloverUtils.createOutFile((FullFileInfo)classInfo.getContainingFile(), outname, this.basePath);
        ArrayList<TestCaseInfo> tests = Lists.newArrayList(classInfo.getTestCases());
        Collections.sort(tests, TEST_CASE_COMPARATOR);
        VelocityContext context = new VelocityContext();
        context.put("currentPageURL", outname);
        this.insertCommonPropsForCurrent(context, classInfo.getPackage().getName());
        context.put("projectInfo", this.getFullModel());
        String link = this.rederingHelper.getTestClassLink(false, classInfo);
        this.insertCommonTestProps(context, tests, "test", classInfo.getPackage(), classInfo, link, "Class", TAB_TESTS);
        HtmlReportUtil.mergeTemplateToFile(outfile, context, "test-class-summary.vm");
    }

    private void insertCommonTestProps(VelocityContext context, List entities, String childEntityType, PackageInfo pkg, HasMetrics entity, String link, String title, String subtitle) {
        context.put("entities", entities);
        context.put("childEntityType", childEntityType);
        if (pkg != null) {
            context.put("packageName", pkg.getName());
            context.put("packageInfo", pkg);
        }
        context.put("entity", entity);
        context.put("entityLink", link);
        context.put("headerMetrics", entity.getMetrics());
        context.put("headerMetricsRaw", entity.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(context, entity);
        context.put("topLevel", Boolean.FALSE);
        context.put("title", title);
        context.put("subtitle", subtitle);
        context.put("hasResults", this.getTestModel().hasTestResults());
        context.put("appPagePresent", pkg == null || this.getConfiguredModel().getNamedPackage(pkg.getName()) != null);
        context.put("testPagePresent", Boolean.TRUE);
    }

    static class TestMethodFilter
    implements HasMetricsFilter {
        TestMethodFilter() {
        }

        @Override
        public boolean accept(HasMetrics hm) {
            return !(hm instanceof MethodInfo) || ((MethodInfo)hm).isTest();
        }
    }

    public static class TreeInfo {
        private String pathPrefix;
        private String name;

        public TreeInfo(String pathPrefix, String name) {
            this.pathPrefix = pathPrefix;
            this.name = name;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String getName() {
            return this.name;
        }

        public String getLowercaseName() {
            return this.name.toLowerCase();
        }

        public String toString() {
            return this.getName();
        }
    }
}

